% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pac_health}
\alias{pac_health}
\title{CRAN package health state at a specific Date or for a specific version}
\usage{
pac_health(
  pac,
  version = NULL,
  at = NULL,
  limit = 14,
  scope = c("ERROR", "FAIL"),
  flavors = NULL,
  lib.loc = .libPaths(),
  repos = "https://cran.rstudio.com/",
  source = c("crandb", "cran")
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{version}{\code{character} version of a package. Default: \code{NULL}}

\item{at}{\code{Date} from which to take the version. Default: \code{NULL}}

\item{limit}{\code{numeric} at least days to treat as healthy, ">=limit". Default: 14}

\item{scope}{\code{character} vector scope of the check, accepted values c("ERROR", "FAIL", "WARN", "NOTE"). Default: \code{c("ERROR", "FAIL")}}

\item{flavors}{\code{character} vector of CRAN server names to consider, possible names could be get with \code{pacs::cran_flavors()$Flavor}.
The \code{pacs::match_flavors()} function could be used to get CRAN server names matched for your local \code{OS}.
By default all CRAN machines are considered \code{NULL} value. Default: \code{NULL}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{character vector repositories URLs to use. Default \verb{https://cran.rstudio.com/}}

\item{source}{\code{character} one of \code{c("crandb", "cran")}. Using the \verb{MEATCRAN CRANDB} or the direct web page download from CRAN. Default: \code{"crandb"}}
}
\value{
\code{logical} if a package is healthy.
}
\description{
a package health for a certain version or at a specific Date.
By default works for the newest package version.
A healthy package was published for more than x days, where default is 14 days.
CRAN team gives around one/two week to resolved a package which gave errors under the check page.
The newest release is checked for any warnings/errors on the R CRAN package check page.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
For \code{source = "cran"}the function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their servers by constantly using this function.
}
\examples{
\dontrun{
pacs::pac_health("memoise")
pacs::pac_health("dplyr", version = "0.8.0", limit = 14)
pacs::pac_health("dplyr", at = as.Date("2019-02-14"))
pacs::pac_health("dplyr", limit = 14, scope = c("ERROR", "FAIL"))
}
}
