% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pact.R
\name{summary.pact}
\alias{summary.pact}
\title{Summarize a predictive model fit}
\usage{
\method{summary}{pact}(object, ...)
}
\arguments{
\item{object}{The object returned from \code{'pact.fit'}}

\item{...}{Additional arguments for 'summary'}
}
\value{
All the coefficient estimates from the regression model fitted by \code{pact.fit}
}
\description{
summary method for objects of class 'pact'
}
\details{
Returns all coefficient estimates from the regression model of the 'pact' object
}
\examples{
data(prostateCancer)
Y <- prostateCancer[,3:4]
Xf <- prostateCancer[,7:8]
Xv <- prostateCancer[,c(5:6,9)]
Treatment <- as.factor(prostateCancer[,2])
p <- pact.fit(Y=Y,Xf=Xf,Xv=Xv,Treatment=Treatment,family="cox",varSelect="none")
summary(p)

}
\author{
Jyothi Subramanian and Richard Simon
\cr Maintainer: Jyothi Subramanian <\email{subramanianj01@gmail.com}>
}

