% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagenum.r
\name{pagenum}
\alias{getPagenum}
\alias{pagenum}
\alias{setPagenum}
\title{Put Page Numbers on Graphics}
\usage{
pagenum(num, text = "Page", date = FALSE, date.format, x = 0.03,
  y = 0.03, just = c("left", "bottom"), col = "gray50", cex = 0.75)

setPagenum(num = 1)

getPagenum()
}
\arguments{
\item{num}{The number to put on the page.  If no number is given,
the value of \code{options()$pagenum} is used.}

\item{text}{The text to use in front of the page number.}

\item{date}{If FALSE (default), do not add a date below the page number.}

\item{date.format}{The format to use for the date.}

\item{x}{Horizontal position of timestamp, in [0,1]. Default .03}

\item{y}{Vertical position of timestamp, in [0,1]. Default .03}

\item{just}{Jufstification.  Default c('left','bottom')}

\item{col}{Color to use for the text.}

\item{cex}{Character expansion. Default 0.75.}
}
\value{
Returns the value stored by the global variable.

Returns the value of options()$pagenum
}
\description{
Put Page Numbers on Graphics
}
\details{
Use \code{setPagenum} to create a global variable with the page number.

If \code{pagenum()} is called without an argument, the value of
\code{options()$pagenum} is used to determine the page number.

Each time \code{pagenum()} is called, \code{options()$pagenum} is
automatically incremented by 1.
}
\examples{
# base graphics
setPagenum(1)
plot(Sepal.Length~Sepal.Width, data=iris, col=Species, pch=19)
pagenum()

# lattice, date
setPagenum(getPagenum()+1) # Manual increment
require(lattice)
xyplot(Sepal.Length~Sepal.Width, data=iris, groups=Species)
pagenum(date=TRUE)

# ggplot2, top-right
require(ggplot2)
ggplot(iris, aes(x=Sepal.Width, y=Sepal.Length,
  color=Species)) + geom_point() + theme_classic()
pagenum(text="ABC Corp - ", date=TRUE,
x=.95, y=.95, just=c('right','top'))

# multiple figures, 'draft' watermark
op = par(mfrow=c(1,2))
plot(Sepal.Length ~ Sepal.Width, data=iris, col=Species, pch=19)
plot(Petal.Length ~ Petal.Width, data=iris, col=Species, pch=19)
par(op)
pagenum(num="", text="Figures 2a, 2b")
pagenum(num="", text="Draft",
        x=.5, y=.95, just=c('center','top'),
        col="wheat", cex=3)

}
\author{
Kevin Wright
}
\references{
Mark Heckmann (2009).
R: Good practice - adding footnotes to graphics.
\url{https://ryouready.wordpress.com/2009/02/17/r-good-practice-adding-footnotes-to-graphics/}
}

