% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.R
\name{Q}
\alias{Q}
\title{Person Fit Index Q}
\usage{
Q(obj, ...)
}
\arguments{
\item{obj}{an object of class \code{"pers"} or class \code{"pair"}as a result from function \code{\link{pers}} or \code{\link{pair}} respectively.}

\item{...}{not used so far.}
}
\value{
a vector holding the Q-index for every person.
}
\description{
function for calculating the person fit index Q, which was proposed by Tarnai and Rost (1990).
}
\details{
The person Q-index proposed by Tarnai and Rost, (1990) is solely based on the empirical responses and the item parameters. Thus the computation of person parameters using the function \code{\link{pers}} is not required - see examples. But for convenience return objects of both functions are accepted in function \code{Q}.
}
\examples{
#######################
data(bfiN) # get some data
ip <- pair(daten = bfiN,m = 6) # item parameters according the partial credit model
Q(ip)
}
\references{
Tarnai, C., & Rost, J. (1990). \emph{Identifying aberrant response patterns in the Rasch model: the Q index}. Münster: ISF.
}
