% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockfile.R
\name{lockfile_create}
\alias{lockfile_create}
\title{Create a lock file}
\usage{
lockfile_create(
  pkg = "deps::.",
  lockfile = "pkg.lock",
  lib = NULL,
  upgrade = FALSE,
  dependencies = NA
)
}
\arguments{
\item{pkg}{Package names or remote package specifications to install.
See \link[=pak_package_sources]{pak package sources} for details.}

\item{lockfile}{Path to the lock file.}

\item{lib}{Package library to install the packages to. Note that \emph{all}
dependent packages will the be installed here, even if they are
already installed in another library.}

\item{upgrade}{When \code{FALSE}, the default, does the minimum amount of work
to give you the latest version of \code{pkg}. It will only upgrade packages if
\code{pkg}, or one of its dependencies, explicitly requires a higher version
than what you currently have.

When \code{upgrade = TRUE}, will do ensure that you have the latest version of
\code{pkg} and all its dependencies.}

\item{dependencies}{Dependency types. See
\code{\link[pkgdepends:as_pkg_dependencies]{pkgdepends::as_pkg_dependencies()}} for possible values. Note that
changing this argument from the default might result an installation
failure, e.g. if you set it to \code{FALSE}, packages might not build if
their dependencies are not already installed.}
}
\description{
The lock file can be used later, possibly in a new R session, to carry
out the installation of the dependencies, with
\code{\link[=lockfile_install]{lockfile_install()}}.
}
\details{
Note, since the URLs of CRAN and most CRAN-like repositories change
over time, in practice you cannot use the lock file \emph{much} later.
For example, binary packages of older package version
might be deleted from the repository, breaking the URLs in the
lock file.

Currently the intended use case of lock files in on CI systems, to
facilitate caching. The (hash of the) lock file provides a good key
for caching systems.
}
\seealso{
Other lock files: 
\code{\link{lockfile_install}()}
}
\concept{lock files}
