% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_geo.R
\name{axis_geo}
\alias{axis_geo}
\alias{axis_geo_phylo}
\title{Add an axis with a geological timescale}
\usage{
axis_geo(
  side = 1,
  intervals = "epoch",
  height = 0.05,
  fill = NULL,
  lab = TRUE,
  lab_col = NULL,
  lab_size = 1,
  rot = 0,
  abbr = TRUE,
  center_end_labels = TRUE,
  skip = c("Quaternary", "Holocene", "Late Pleistocene"),
  bord_col = "black",
  lty = par("lty"),
  lwd = par("lwd"),
  bkgd = "grey90",
  neg = FALSE,
  exact = FALSE,
  round = FALSE,
  tick_at = NULL,
  tick_labels = TRUE,
  phylo = FALSE,
  root.time = NULL,
  ...
)

axis_geo_phylo(...)
}
\arguments{
\item{side}{\code{integer}. Which side to add the axis to (\code{1}: bottom,
the default; \code{2}: left; \code{3}: top; \code{4}: right).}

\item{intervals}{The interval information to use to plot the axis: either A)
a \code{character} string indicating a rank of intervals from the built-in
\code{\link{GTS2020}}, B) a \code{character} string indicating a
\code{data.frame} hosted by \href{https://macrostrat.org}{Macrostrat} (see
\code{\link{time_bins}}), or C) a custom \code{data.frame} of time interval
boundaries (see Details). A list of strings or data.frames can be supplied
to add multiple time scales to the same side of the plot (see Details).}

\item{height}{\code{numeric}. The relative height (or width if \code{side} is
\code{2} or \code{4}) of the scale. This is relative to the height (if
\code{side} is \code{1} or \code{3}) or width (if \code{side} is \code{2}
or \code{4}) of the plot.}

\item{fill}{\code{character}. The fill colour of the boxes. The default is to
use the \code{colour} or \code{color} column included in \code{intervals}.
If a custom dataset is provided with \code{intervals} without a
\code{colour} or \code{color} column and without specifying \code{fill}, a
greyscale will be used. Custom fill colours can be provided with this
option (overriding the \code{colour} or \code{color} column) and will be
recycled if/as necessary.}

\item{lab}{\code{logical}. Should interval labels be included?}

\item{lab_col}{\code{character}. The colour of the labels. The default is to
use the \code{font} or \code{lab_color} column included in
\code{intervals}. If a custom dataset is provided with \code{intervals}
without a \code{font} or \code{lab_color} column and without
specifying \code{lab_col}, all labels will be black. Custom label colours
can be provided with this option (overriding the \code{font} or
\code{lab_color} column) and will be recycled if/as necessary.}

\item{lab_size}{\code{numeric}. The size of the labels (see \code{cex} in
\code{\link[graphics:par]{graphics parameters}}).}

\item{rot}{\code{numeric}. The amount of counter-clockwise rotation to add to
the labels (in degrees). Note, labels for axes added to the left or right
sides are already rotated 90 degrees.}

\item{abbr}{\code{logical}. Should labels be abbreviated? This only works
if the data has an \code{abbr} column, otherwise the \code{name} column
will be used regardless of this setting.}

\item{center_end_labels}{\code{logical}. Should labels be centered within the
visible range of intervals at the ends of the axis?}

\item{skip}{A \code{character} vector of interval names indicating which
intervals should not be labeled. If \code{abbr} is \code{TRUE}, this can
also include interval abbreviations. Quaternary, Holocene, and Late
Pleistocene are skipped by default. Set to NULL if this is not desired.}

\item{bord_col}{\code{character}. The border colour of the interval boxes.}

\item{lty}{\code{character}. Line type (see \code{lty} in
\code{\link[graphics:par]{graphics parameters}}). This value (or the last
value if this is a list) will also be passed to
\code{\link[graphics]{axis}}.}

\item{lwd}{\code{numeric}. Line width (see \code{lwd} in
\code{\link[graphics:par]{graphics parameters}}).}

\item{bkgd}{\code{character}. The colour of the background of the scale
when no intervals are being shown.}

\item{neg}{\code{logical}. Set this to \code{TRUE} if your x-axis is using
negative values. If the entire axis is already negative, this will be set
to \code{TRUE} for you.}

\item{exact}{\code{logical}. Set this to \code{TRUE} if you want axis tick
marks and numeric tick labels placed at the interval boundaries.}

\item{round}{\code{integer}. Number of decimal places to which exact axis
labels should be rounded (using \code{\link[base]{round}}). If no value is
specified, the exact values will be used. Trailing zeros are always
removed. \code{tick_at} and \code{tick_labels} can be used to include
labels with trailing zeros.}

\item{tick_at}{A \code{numeric} vector specifying custom points at which tick
marks are to be drawn on the axis. If specified, this is passed directly to
\code{\link[graphics]{axis}}. The default is to compute tick mark locations
automatically (see \code{\link[graphics]{axTicks}}).}

\item{tick_labels}{Either a) a \code{logical} value specifying whether
(numerical) annotations should be made at the tick marks specified by
\code{at}, or b) a custom \code{character} or \code{expression} vector of
labels to be placed at the tick marks. If \code{at} is specified, this
argument is passed directly to \code{\link[graphics]{axis}}.}

\item{phylo}{\code{logical}. Is the base plot a phylogeny generated by
\code{\link[ape]{plot.phylo}}, \code{\link[phytools]{plotTree}},
\code{\link[phytools]{plotSimmap}}, etc?}

\item{root.time}{\code{numeric}. If \code{phylo} is \code{TRUE}, this is the
time assigned to the root node of the tree. By default, this is taken from
the \code{root.time} element of the plotted tree.}

\item{...}{Further arguments that are passed directly to
\code{\link[graphics]{axis}}.}
}
\value{
No return value. Function is used for its side effect, which is to
add an axis of the geological timescale to an already existing plot.
}
\description{
\code{axis_geo} behaves similarly to \code{\link[graphics]{axis}} in that it
adds an axis to the specified side of a base R plot. The main difference is
that it also adds a geological timescale between the plot and the axis. The
default scale includes international epochs from the the Geological Timescale
2020 (\code{\link{GTS2020}}). However, international stages, periods, eras,
and eons are also available. Interval data hosted by
\href{https://macrostrat.org}{Macrostrat} are also available (see
\code{\link{time_bins}}). A custom interval dataset can also be used (see
Details below). The appearance of the axis is highly customisable (see Usage
below), with the intent that plots will be publication-ready.
}
\details{
If a custom \code{data.frame} is provided (with \code{intervals}), it should
consist of at least 3 columns of data. See \code{\link{GTS2020}} for an
example.
\itemize{
\item The \code{interval_name} column (\code{name} is also allowed) lists
the names of each time interval. These will be used as labels if no
abbreviations are provided.
\item The \code{max_ma} column (\code{max_age} is also allowed) lists the
oldest boundary of each time interval. Values should always be
positive.
\item The \code{min_ma} column (\code{min_age} is also allowed) lists the
youngest boundary of each time interval. Values should always be
positive.
\item The \code{abbr} column is optional and lists abbreviations that may
be used as labels.
\item The \code{colour} column (\code{color} is also allowed) is also
optional and lists a colour for the background for each time interval
(see the Color Specification section
\code{\link[graphics:par]{here}}).
\item The \code{font} (\code{lab_color} is also allowed) column is
also optional and lists a colour for the label for each time interval
(see the Color Specification section
\code{\link[graphics:par]{here}}).
}

\code{intervals} may also be a list if multiple time scales should be added
to a single side of the plot. In this case, \code{height}, \code{fill},
\code{lab}, \code{lab_col}, \code{lab_size}, \code{rot}, \code{abbr},
\code{center_end_labels}, \code{skip}, \code{bord_col}, \code{lty}, and
\code{lwd} can also be lists. If these lists are not as long as
\code{intervals}, the elements will be recycled. If individual values
(or vectors, e.g. for \code{skip}) are used for these parameters, they will
be applied to all time scales (and recycled as necessary). If multiple scales
are requested they will be added sequentially outwards starting from the plot
border. The axis will always be placed on the outside of the last scale.

If you would like to use intervals from the Geological Time Scale 2012
(\code{\link{GTS2012}}), you can use \code{\link{time_bins}} and supply the
returned \code{data.frame} to the \code{intervals} argument.

\code{axis_geo_phylo(...)} is shorthand for
\code{axis_geo(..., phylo = TRUE)}.
}
\section{Authors}{

William Gearty & Kilian Eichenseer
}

\section{Reviewer}{

Lewis A. Jones
}

\examples{
# track user par
oldpar <- par(no.readonly = TRUE)
# single scale on bottom
par(mar = c(6.1, 4.1, 4.1, 2.1)) # modify margin
plot(0:100, axes = FALSE, xlim = c(100, 0), ylim = c(100, 0),
     xlab = NA, ylab = "Depth (m)")
box()
axis(2)
axis_geo(side = 1, intervals = "period")
# the line argument here depends on the absolute size of the plot
title(xlab = "Time (Ma)", line = 4)

# stack multiple scales, abbreviate only one set of labels
par(mar = c(7.1, 4.1, 4.1, 2.1)) # further expand bottom margin
plot(0:100, axes = FALSE, xlim = c(100, 0), ylim = c(100, 0),
     xlab = NA, ylab = "Depth (m)")
box()
axis(2)
axis_geo(side = 1, intervals = list("epoch", "period"),
    abbr = list(TRUE, FALSE))
# the line argument here depends on the absolute size of the plot
title(xlab = "Time (Ma)", line = 6)

# scale with MacroStrat intervals
par(mar = c(6.1, 4.1, 4.1, 2.1)) # modify margin
plot(0:30, axes = FALSE, xlim = c(30, 0), ylim = c(30, 0),
     xlab = NA, ylab = "Depth (m)")
box()
axis(2)
axis_geo(side = 1, intervals = "North American land mammal ages")
# the line argument here depends on the absolute size of the plot
title(xlab = "Time (Ma)", line = 4)

# scale with custom intervals
intervals <- data.frame(min_ma = c(0, 10, 25, 32),
                        max_ma = c(10, 25, 32, 40),
                        interval_name = c("A", "B", "C", "D"))
par(mar = c(6.1, 4.1, 4.1, 2.1)) # modify margin
plot(0:40, axes = FALSE, xlim = c(40, 0), ylim = c(40, 0),
     xlab = NA, ylab = "Depth (m)")
box()
axis(2)
axis_geo(side = 1, intervals = intervals)
# the line argument here depends on the absolute size of the plot
title(xlab = "Time (Ma)", line = 4)

\dontshow{if (require(phytools)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# scale with phylogeny
library(phytools)
data(mammal.tree)
plot(mammal.tree)
axis_geo_phylo()
title(xlab = "Time (Ma)", line = 4)
\dontshow{\}) # examplesIf}
\dontshow{if (require(paleotree)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# scale with fossil phylogeny
library(paleotree)
data(RaiaCopesRule)
plot(ceratopsianTreeRaia)
axis_geo_phylo()
title(xlab = "Time (Ma)", line = 4)

# reset user par
par(oldpar)
\dontshow{\}) # examplesIf}
}
