% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden.R
\name{other}
\alias{other}
\alias{.prepare}
\alias{.simulate}
\alias{.predict}
\alias{.select}
\title{Analysis functions for manuscript}
\usage{
.prepare(X, filter = 1, cutoff = "zero", scale = TRUE)

.simulate(x, effects)

.predict(
  y,
  X,
  nfolds.ext = 5,
  nfolds.int = 5,
  adaptive = TRUE,
  standard = TRUE,
  elastic = TRUE,
  shrink = TRUE,
  family = "binomial",
  ...
)

.select(y, X, index, nfolds = 5, standard = TRUE, adaptive = TRUE, ...)
}
\arguments{
\item{X}{covariates\strong{:}
matrix with \eqn{n} rows and \eqn{p} columns}

\item{filter}{numeric, multiplying the sample size}

\item{cutoff}{character "zero", "knee", or "half"}

\item{scale}{logical}

\item{x}{covariates\strong{:}
list of length \eqn{k},
including matrices with \eqn{n} rows and \eqn{p} columns}

\item{effects}{number of causal covariates\strong{:}
vector of length \eqn{k}}

\item{y}{response\strong{:}
vector of length \eqn{n}}

\item{nfolds.ext}{number of external folds}

\item{...}{arguments for \link[palasso]{palasso}}

\item{index}{indices of causal covariates\strong{:}
list of length \eqn{k},
including vectors}

\item{trial}{development option}
}
\description{
Functions for the \code{palasso} manuscript.
}
\details{
\code{.prepare}\strong{:}
pre-processes sequencing data by
removing features with a low total abundance,
and adjusting for different library sizes;
obtains two transformations of the same data
by (1) binarising the counts with some cutoff
and (2) taking the Anscombe transform;
scales all covariates to mean zero and unit variance.

\code{.simulate}\strong{:}
simulates the response by
exploiting two experimental covariate matrices;
allows for different numbers of non-zero coefficients for X and Z.

\code{.predict}\strong{:}
estimates the predictive performance of different lasso models
(standard X and/or Z, adaptive X and/or Z, paired X and Z);
minimises the loss function "deviance", but also returns other loss functions;
supports logistic and Cox regression.

\code{.select}\strong{:}
estimates the selective performance of different lasso models
(standard X and/or Z, adaptive X and/or Z, paired X and Z);
limits the number of covariates to \eqn{10};
returns the number of selected covariates,
and the number of correctly selected covariates.
}
\examples{
\donttest{set.seed(1)
n <- 30; p <- 40
X <- matrix(rpois(n*p,lambda=3),nrow=n,ncol=p)
x <- palasso:::.prepare(X)
y <- palasso:::.simulate(x,effects=c(1,2))
predict <- palasso:::.predict(y,x)
select <- palasso:::.select(y,x,attributes(y))}
}
\seealso{
Use \link[palasso]{palasso} to fit the paired lasso.
}
\keyword{internal}
