% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{read.paleoTS}
\alias{read.paleoTS}
\title{Read a text-file with data from a paleontological time-series}
\usage{
read.paleoTS(file = NULL, oldest = "first", reset.time = TRUE, ...)
}
\arguments{
\item{file}{file name; if not supplied, an interactive window prompts the
user to navigate to the text file}

\item{oldest}{"first" if samples are in order from oldest to youngest, "last"
if the opposite}

\item{reset.time}{logical; see \code{\link{as.paleoTS}}}

\item{...}{other arguments, passed to \code{read.table}}
}
\value{
a \code{paleoTS} object
}
\description{
Read a text-file with data from a paleontological time-series
}
\details{
This function reads a text file with a specified format and converts
  it into a \code{paleoTS} object. It will often be the easiest way for users
  to import their own data. The text file should have four columns without
  headers, in this order: sample size, sample means, sample variances, sample
  ages.
}
\seealso{
\code{\link{as.paleoTS}}
}
