% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_ref_specimens}
\alias{pbdb_ref_specimens}
\title{Get references for fossil specimens}
\usage{
pbdb_ref_specimens(...)
}
\arguments{
\item{...}{Arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/specs/refs}. E.g.:
\itemize{
\item \code{spec_id}: List of specimen identifiers.
\item \code{base_name}: Return only records associated with the specified
taxonomic name(s), including all subtaxa and synonyms.
\item \code{ref_author}: Select only references for which any of the authors
matches the specified name.
\item \code{ref_pubyr}: Select only references published in the specified
year.
\item \code{pub_title}: Select only references that involve the specified
publication.
}}
}
\value{
A data frame with the information about the references that
match the query.
}
\description{
Returns information about the bibliographic references associated
with the selected fossil specimens.
}
\examples{
\dontrun{
pbdb_ref_specimens(spec_id = c(1505, 30050))
}
}
