% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoFilter2.R
\name{geoFilter2}
\alias{geoFilter2}
\title{Conversion between run_ids and geo objects often contain NA/NULL values
This removes NA-containing rows}
\usage{
geoFilter2(palm.sra, wobble = FALSE, wradius = 0.005)
}
\arguments{
\item{palm.sra}{data.frame, output df from get.sraGeo()}

\item{wobble}{boolean, add a wobble to each point to prevent overplotting [FALSE]}

\item{wradius}{numeric, maximum magnitude of wobble [0.005]}
}
\value{
modified palm.sra data.frame
}
\description{
Conversion between run_ids and geo objects often contain NA/NULL values
This removes NA-containing rows
}
\examples{

data("waxsys.palm.sra")
# waxsys.palm.sra
# -- 4159 rows

waxsys.geo.filtered <- geoFilter2(waxsys.palm.sra)
# -- 2300 rows

# 2300 / 4159 SRA-libraries have associated geospatial meta-data

}
\keyword{geo}
\keyword{palmid}
