% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_bg_data.R
\name{make_bg_data}
\alias{make_bg_data}
\title{Read a multiple-FEV file to create a background set of palmprints
Standard approach is to use palmDB}
\usage{
make_bg_data(fev.path, dataset.id = NULL, return.data = TRUE)
}
\arguments{
\item{fev.path}{Path to multiple fev file}

\item{dataset.id}{Name for output dataset.}

\item{return.data}{Boolean. Return data.frame instead of writing file [TRUE]}
}
\value{
NULL: will write an RData file to data/<fev.path>.RData
}
\description{
Read a multiple-FEV file to create a background set of palmprints
Standard approach is to use palmDB
}
\examples{

#' # palmscan example fev file
ps.fev.path <- system.file( "extdata", "waxsys.fev", package = "palmid")
example_bg <- make_bg_data(fev.path = ps.fev.path, dataset.id = 'example_bg')

## Documentation on Making Background Dataset from palmDB
##  i.e. load("palmdb")
## 
## Download palmDB to make background set
# system("git clone https://github.com/rcedgar/palmdb.git")
#
## Generate the palmprint-FEV with palmscan
# system("palmscan -search_pp palmdb/2021-03-02/otu_centroids.fa \
#         -all -rdrp -fevout data/palmdb210302.fev")
#
## Create R object (data.frame)
# make_bg_data(fev.path = "data/palmdb210302.fev",
#              dataset.it = "palmdb",
#              return.data = FALSE)
#
# load("palmdb")

}
\keyword{palmdb}
\keyword{palmid}
\keyword{palmprints}
