% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eilers_peeters.R
\name{eilers_peeters_generate_regression_ETR_I}
\alias{eilers_peeters_generate_regression_ETR_I}
\title{Eilers-Peeters Regression for  ETR I}
\usage{
eilers_peeters_generate_regression_ETR_I(
  data,
  a_start_value = eilers_peeters_default_start_value_a,
  b_start_value = eilers_peeters_default_start_value_b,
  c_start_value = eilers_peeters_default_start_value_c
)
}
\arguments{
\item{data}{A \code{data.table} from \code{read_dual_pam_data}.}

\item{a_start_value}{Numeric. Starting value for \eqn{a}. Default: \code{a_start_values_eilers_peeters_default}.}

\item{b_start_value}{Numeric. Starting value for \eqn{b}. Default: \code{b_start_values_eilers_peeters_default}.}

\item{c_start_value}{Numeric. Starting value for \eqn{c}. Default: \code{c_start_values_eilers_peeters_default}.}
}
\value{
A list containing:
\itemize{
  \item \code{etr_regression_data}: Predicted ETR values.
  \item \code{sdiff}: Deviation between actual and predicted values.
  \item \code{a}, \code{b}, \code{c}: Fitted parameters.
  \item \code{pm}: Maximum ETR (\eqn{p_m}).
  \item \code{s}: Initial slope (\eqn{s}).
  \item \code{ik}: Transition point from light limitation to light saturation (\eqn{I_k}).
  \item \code{im}: PAR at maximum ETR (\eqn{I_m}).
  \item \code{w}: Peak sharpness (\eqn{w}).
}
}
\description{
Fits a regression model for ETR I based on Eilers-Peeters (1988), considering photoinhibition.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#eilers_peeters_generate_regression_etr_i-and-eilers_peeters_generate_regression_etr_ii}.
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- eilers_peeters_generate_regression_ETR_I(data)

}
\references{
{
  Eilers, P. H. C., & Peeters, J. C. H. (1988). \emph{A model for the relationship between light intensity and the rate of photosynthesis in phytoplankton.}
  Ecological Modelling, 42(3-4), 199-215. Available at: \doi{10.1016/0304-3800(88)90057-9}
}
}
