% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdftoj.R
\name{tojecdf}
\alias{tojecdf}
\title{The TOJ bias-corrected empirical CDF estimation}
\usage{
tojecdf(data, acov_order = 0, acor_order = 1, R = 1000, ci = TRUE)
}
\arguments{
\item{data}{A matrix of panel data.
Each row corresponds to individual time series.}

\item{acov_order}{A non-negative integer of the order of autocovariance.
Default is 0.}

\item{acor_order}{A positive integer of the order of autocorrelation.
Default is 1.}

\item{R}{A positive integer of the number of bootstrap repetitions.
Default is 1000.}

\item{ci}{A logical whether to estimate the confidence interval.
Default is TRUE.}
}
\value{
A list that contains the following elements.
\item{mean}{A plot of the corresponding CDF}
\item{acov}{A plot of the corresponding CDF}
\item{acor}{A plot of the corresponding CDF}
\item{mean_func}{A function that returns the corresponding CDF}
\item{acov_func}{A function that returns the corresponding CDF}
\item{acor_func}{A function that returns the corresponding CDF}
\item{mean_ci_func}{A function that returns the 95 percent confidence
interval for the corresponding CDF}
\item{acov_ci_func}{A function that returns the 95 percent confidence
interval for the corresponding CDF}
\item{acor_ci_func}{A function that returns the 95 percent confidence
interval for the corresponding CDF}
\item{quantity}{A matrix of the estimated heterogeneous quantities}
\item{acov_order}{The order of autocovariance}
\item{acor_order}{The order of autocorrelation}
\item{N}{The number of cross-sectional units}
\item{S}{The length of time series}
\item{R}{The number of bootstrap repetitions}
}
\description{
The `tojecdf()` function enables to implement the TOJ bias-corrected
estimation of the cumulative distribution function (CDF) of
the heterogeneous mean, the heterogeneous autocovariance, and
the heterogeneous autocorrelation.
The method is developed by Okui and Yanagi (2019).
For more details, see the package vignette with `vignette("panelhetero")`.
}
\examples{
data <- panelhetero::simulation(N = 300, S = 50)
panelhetero::tojecdf(data = data, R = 50)

}
\references{
Okui, R. and Yanagi, T., 2019.
Panel data analysis with heterogeneous dynamics.
Journal of Econometrics, 212(2), pp.451-475.
}
