% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heise.R
\name{heise}
\alias{heise}
\title{Estimate Heise stability and reliability coefficients}
\usage{
heise(data, ..., waves = NULL)
}
\arguments{
\item{data}{A \code{panel_data} frame.}

\item{...}{unquoted variable names that are passed to \code{\link[dplyr:select]{dplyr::select()}}}

\item{waves}{Which 3 waves should be used? If NULL (the default), the
first, middle, and last waves are used.}
}
\value{
A \code{tibble} with reliability (\code{rel}), waves 1-3 stability (\code{stab13}),
waves 1-2 stability (\code{stab12}), and waves 2-3 stability (\code{stab23}) and
the variable these values refer to (\code{var}).
}
\description{
This function uses three waves of data to estimate stability
and reliability coefficients as described in Heise (1969).
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
heise(wages, wks, lwage) # will use waves 1, 4, and 7 by default
}
\references{
Heise, D. R. (1969). Separating reliability and stability in test-retest
correlation. \emph{American Sociological Review}, \emph{34}, 93–101.
https://doi.org/10.2307/2092790
}
