% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{fevd_orthogonal}
\alias{fevd_orthogonal}
\alias{fevd_orthogonal.pvargmm}
\title{Forcast Error Variance Decomposition for PVAR}
\usage{
fevd_orthogonal(model, n.ahead = 10)

\method{fevd_orthogonal}{pvargmm}(model, n.ahead = 10)
}
\arguments{
\item{model}{A PVAR model}

\item{n.ahead}{Number of steps}
}
\value{
A list with forecast error variances as matrices for each variable.
}
\description{
Computes the forecast error variance decomposition of a PVAR(p) model.
}
\details{
The estimation is based on orthogonalised impulse response functions.
}
\note{
A \code{plot} method will be provided in future versions.
}
\examples{
data("ex1_dahlberg_data")
fevd_orthogonal(ex1_dahlberg_data, n.ahead = 8)

}
\references{
Pfaff, B. (2008) VAR, SVAR and SVEC Models: Implementation Within R Package vars, \emph{Journal of Statistical Software} \bold{27}(4) \url{http://www.jstatsoft.org/v27/i04/}
}
\seealso{
\code{\link{pvargmm}} for model estimaion

\code{\link{oirf}} for orthogonal impulse response function
}
