% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/papaja.R
\docType{package}
\name{papaja}
\alias{papaja}
\title{Prepare APA Journal Articles with R Markdown}
\description{
\code{papaja} is an \href{https://improvingpsych.org/mission/awards/}{award-winning} R package that facilitates creating computationally reproducible, submission-ready manuscripts which conform to the American Psychological Association (APA) manuscript guidelines (6th Edition).
}
\details{
\code{papaja} provides
\itemize{
\item an \href{https://rmarkdown.rstudio.com/}{R Markdown} template that can be used with (or without) \href{https://www.rstudio.com/}{RStudio} to create PDF documents (using the \href{https://ctan.org/pkg/apa6}{apa6} LaTeX class) or Word documents (using a .docx-reference file).
\item Functions to \emph{typeset} the results from \emph{statistical analyses} (e.g., \code{\link[=apa_print]{apa_print()}}),
\item functions to create \emph{tables} (\code{\link[=apa_table]{apa_table()}}), and
\item functions to create \emph{figures} in accordance with APA guidelines (e.g., \code{\link[=apa_factorial_plot]{apa_factorial_plot()}}).
}
}
\section{System requirements}{

To use \code{papaja} you need either an up-to-date version of
\href{https://www.rstudio.com/}{RStudio} or
\href{https://pandoc.org/}{pandoc}. If you want to create PDF-
in addition to DOCX-documents you additionally need a
\href{https://en.wikipedia.org/wiki/TeX}{TeX} distribution. We recommend
\href{https://yihui.org/tinytex/}{TinyTex}, which can be installed from within
R via the \pkg{tinytex} package.

Please refer to the \href{http://frederikaust.com/papaja_man/introduction.html#getting-started}{\code{papaja} manual}
for detailed installation instructions.
}

\section{Getting help}{

For a comprehensive introduction to \code{papaja}, see the current draft of the \href{http://frederikaust.com/papaja_man/}{manual}.
If you have a specific question that is not answered in the manual, feel free to ask a question on Stack Overflow \href{https://stackoverflow.com/questions/tagged/papaja}{using the \code{papaja} tag}.
If you believe you have found a bug or would like to request a new feature, \href{https://github.com/crsh/papaja/issues}{open an issue} on Github and provide a \href{https://stackoverflow.com/help/mcve}{minimal complete verifiable example}.
}

\section{Authors}{

Frederik Aust (frederik.aust at uni-koeln.de).
Marius Barth (marius.barth at uni-koeln.de).
}

\section{Maintainer}{

Frederik Aust (frederik.aust at uni-koeln.de).
}

