% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeroc_predict.R
\name{timeroc_predict}
\alias{timeroc_predict}
\title{timeroc_predict}
\usage{
timeroc_predict(
  obj,
  t,
  newx,
  cutoff = 100,
  B = 1,
  type = "standard",
  params.x,
  params.t,
  copula,
  method = "mle",
  definition = "c/d",
  seed,
  params.copula,
  params.ph,
  ci = 0.95,
  h = -1e-04
)
}
\arguments{
\item{obj}{A 'fitTROC' or 'TimeROC' object.\cr}

\item{t}{A numeric/vector specifying time point of interest. (Default: Time-to-event at 50th quantile points)\cr}

\item{newx}{A numeric/vector specifying biomarker of interest.\cr}

\item{cutoff}{A numeric specifying total cutoff point on ROC curve.\cr}

\item{B}{An integer specifying bootstrap iteration. If B > 1, will also return confidence interval.\cr}

\item{type}{A string indicate type of analysis to run. (Default = 'standard')\cr}

\item{params.x}{A named vector for biomarker's parameter.\cr}

\item{params.t}{A named vector for time-to-event's parameter.\cr}

\item{copula}{A string indicating the type of copula to be used.\cr}

\item{method}{A string specifying method of estimation. (Default = 'mle') \cr}

\item{definition}{A string indicating ROC definition to use. (Default = 'c/d') \cr}

\item{seed}{A numeric to pass in set.seed.\cr}

\item{params.copula}{An integer specifying the copula's parameter.\cr}

\item{params.ph}{An integer specifying the PH parameter.\cr}

\item{ci}{An integer 0 to 1 for confidence level.\cr}

\item{h}{An integer specifying small change of time (To compute density from S(t|x)) \cr}
}
\value{
A list of ROC dataframe for each time-to-event.
}
\description{
Predict time-dependent ROC from fitted model.
}
\examples{
# PH model
test <- timeroc_obj('normal-weibull-PH')
set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0.1, n=500,
               params.t = c(shape=1, scale=5),
               params.x = c(mean=5, sd=1),
               params.ph=0.5)
cc <- timeroc_fit(x=rr$x, t=rr$t, event=rr$event, obj = test)
start.t <- Sys.time()
jj <- timeroc_predict(cc)
print(Sys.time()-start.t)


# Copula model
test <- timeroc_obj(dist = 'gompertz-gompertz-copula', copula='clayton90',
params.t = c(shape=3,rate=1),
params.x = c(shape=1,rate=2),
params.copula=-5)
set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0.2, n=500)
cc <- timeroc_fit(x=rr$x, t=rr$t, event=rr$event, obj = test)
start.t <- Sys.time()
jj <- timeroc_predict(cc)
print(Sys.time()-start.t)

}
