% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SyncBackend.R
\name{SyncBackend}
\alias{SyncBackend}
\title{SyncBackend}
\description{
This is a concrete implementation of the abstract class \code{\link{Backend}}
that implements the \code{\link{Service}} interface. This backend executes
tasks in parallel on a \code{\link[parallel:makeCluster]{parallel::makeCluster()}} cluster synchronously (i.e.,
blocking the main \code{R} session).
}
\examples{
# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 2)

# Set the cluster type.
specification$set_type(type = "psock")

# Create a synchronous backend object.
backend <- SyncBackend$new()

# Start the cluster on the backend.
backend$start(specification)

# Check if there is anything on the backend.
backend$peek()

# Create a dummy variable.
name <- "parabar"

# Export the variable from the current environment to the backend.
backend$export("name", environment())

# Remove variable from current environment.
rm(name)

# Run an expression on the backend, using the exported variable `name`.
backend$evaluate({
    # Print the name.
    print(paste0("Hello, ", name, "!"))
})

# Run a task in parallel (i.e., approx. 1.25 seconds).
backend$sapply(
    x = 1:10,
    fun = function(x) {
        # Sleep a bit.
        Sys.sleep(0.25)

        # Compute something.
        output <- x + 1

        # Return the result.
        return(output)
    }
)

# Get the task output.
backend$get_output()

# Clear the backend.
backend$clear()

# Check that there is nothing on the cluster.
backend$peek()

# Stop the backend.
backend$stop()

# Check that the backend is not active.
backend$active

}
\seealso{
\code{\link{Service}}, \code{\link{Backend}}, \code{\link{AsyncBackend}}, and
\code{\link{Context}}.
}
\section{Super classes}{
\code{\link[parabar:Service]{parabar::Service}} -> \code{\link[parabar:Backend]{parabar::Backend}} -> \code{SyncBackend}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SyncBackend-new}{\code{SyncBackend$new()}}
\item \href{#method-SyncBackend-finalize}{\code{SyncBackend$finalize()}}
\item \href{#method-SyncBackend-start}{\code{SyncBackend$start()}}
\item \href{#method-SyncBackend-stop}{\code{SyncBackend$stop()}}
\item \href{#method-SyncBackend-clear}{\code{SyncBackend$clear()}}
\item \href{#method-SyncBackend-peek}{\code{SyncBackend$peek()}}
\item \href{#method-SyncBackend-export}{\code{SyncBackend$export()}}
\item \href{#method-SyncBackend-evaluate}{\code{SyncBackend$evaluate()}}
\item \href{#method-SyncBackend-sapply}{\code{SyncBackend$sapply()}}
\item \href{#method-SyncBackend-lapply}{\code{SyncBackend$lapply()}}
\item \href{#method-SyncBackend-apply}{\code{SyncBackend$apply()}}
\item \href{#method-SyncBackend-get_output}{\code{SyncBackend$get_output()}}
\item \href{#method-SyncBackend-clone}{\code{SyncBackend$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-new"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{SyncBackend}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{\link{SyncBackend}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-finalize}{}}}
\subsection{Method \code{finalize()}}{
Destroy the current \code{\link{SyncBackend}} instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$finalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{\link{SyncBackend}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-start"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-start}{}}}
\subsection{Method \code{start()}}{
Start the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$start(specification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{specification}}{An object of class \code{\link{Specification}}
that contains the backend configuration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The resulting backend must be stored in the
\code{.cluster} private field on the \code{\link{Backend}} abstract class,
and accessible to any concrete backend implementations via the active
binding \code{cluster}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-stop"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-stop}{}}}
\subsection{Method \code{stop()}}{
Stop the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$stop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-clear"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-clear}{}}}
\subsection{Method \code{clear()}}{
Remove all objects from the backend. This function is equivalent to
calling \code{rm(list = ls(all.names = TRUE))} on each node in the
backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-peek"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-peek}{}}}
\subsection{Method \code{peek()}}{
Inspect the backend for variables available in the \code{.GlobalEnv}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$peek()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns a list of character vectors, where each element
corresponds to a node in the backend. The character vectors contain
the names of the variables available in the \code{.GlobalEnv} on each
node.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-export"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-export}{}}}
\subsection{Method \code{export()}}{
Export variables from a given environment to the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$export(variables, environment)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variables}}{A character vector of variable names to export.}

\item{\code{environment}}{An environment object from which to export the
variables. Defaults to the parent frame.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluate an arbitrary expression on the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$evaluate(expression)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expression}}{An unquoted expression to evaluate on the backend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns the result of the expression evaluation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-sapply}{}}}
\subsection{Method \code{sapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$sapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-lapply"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-lapply}{}}}
\subsection{Method \code{lapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parLapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$lapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-apply"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-apply}{}}}
\subsection{Method \code{apply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parApply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$apply(x, margin, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{An array to pass to the \code{fun} function.}

\item{\code{margin}}{A numeric vector indicating the dimensions of \code{x} the
\code{fun} function should be applied over. For example, for a matrix,
\code{margin = 1} indicates applying \code{fun} rows-wise, \code{margin = 2}
indicates applying \code{fun} columns-wise, and \code{margin = c(1, 2)}
indicates applying \code{fun} element-wise. Named dimensions are also
possible depending on \code{x}. See \code{\link[parallel:clusterApply]{parallel::parApply()}} and
\code{\link[base:apply]{base::apply()}} for more details.}

\item{\code{fun}}{A function to apply to \code{x} according to the \code{margin}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-get_output}{}}}
\subsection{Method \code{get_output()}}{
Get the output of the task execution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$get_output(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments currently not in use.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method fetches the output of the task execution after calling
the \code{sapply()} method. It returns the output and immediately removes
it from the backend. Therefore, subsequent calls to this method will
return \code{NULL}. This method should be called after the execution of a
task.
}

\subsection{Returns}{
A vector, matrix, or list of the same length as \code{x}, containing the
results of the \code{fun}. The output format differs based on the specific
operation employed. Check out the documentation for the \code{apply}
operations of \code{\link[parallel:parallel-package]{parallel::parallel}} for more information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SyncBackend-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SyncBackend-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SyncBackend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
