% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamSetCollection.R
\name{ParamSetCollection}
\alias{ParamSetCollection}
\title{ParamSetCollection}
\description{
A collection of multiple \link{ParamSet} objects.
\itemize{
\item The collection is basically a light-weight wrapper / container around references to multiple sets.
\item In order to ensure unique param names, every param in the collection is referred to with
"<set_id>.<param_id>". Parameters from ParamSets with empty (i.e. \code{""}) \verb{$set_id} are referenced
directly. Multiple ParamSets with \verb{$set_id} \code{""} can be combined, but their parameter names
must be unique.
\item Operation \code{subset} is currently not allowed.
\item Operation \code{add} currently only works when adding complete sets not single params.
\item When you either ask for 'values' or set them, the operation is delegated to the individual,
contained param set references. The collection itself does not maintain a \code{values} state.
This also implies that if you directly change \code{values} in one of the referenced sets,
this change is reflected in the collection.
\item Dependencies: It is possible to currently handle dependencies
\itemize{
\item regarding parameters inside of the same set - in this case simply
add the dependency to the set, best before adding the set to the collection
\item across sets, where a param from one set depends on the state
of a param from another set - in this case add call \code{add_dep} on the collection.
}

If you call \code{deps} on the collection, you are returned a complete table of dependencies, from sets and across sets.
}
}
\section{Super class}{
\code{\link[paradox:ParamSet]{paradox::ParamSet}} -> \code{ParamSetCollection}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{params}}{(named \code{list()})\cr
List of \link{Param}, named with their respective ID.}

\item{\code{params_unid}}{(named \code{list()})\cr
List of \link{Param}, named with their true ID. However,
this field has the \link{Param}'s \verb{$id} value set to a
potentially invalid value. This active binding should
only be used internally.}

\item{\code{deps}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Table has cols \code{id} (\code{character(1)}) and \code{on} (\code{character(1)}) and \code{cond} (\link{Condition}).
Lists all (direct) dependency parents of a param, through parameter IDs.
Internally created by a call to \code{add_dep}.
Settable, if you want to remove dependencies or perform other changes.}

\item{\code{values}}{(named \code{list()})\cr
Currently set / fixed parameter values.
Settable, and feasibility of values will be checked when you set them.
You do not have to set values for all parameters, but only for a subset.
When you set values, all previously set values will be unset / removed.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParamSetCollection-new}{\code{ParamSetCollection$new()}}
\item \href{#method-ParamSetCollection-add}{\code{ParamSetCollection$add()}}
\item \href{#method-ParamSetCollection-remove_sets}{\code{ParamSetCollection$remove_sets()}}
\item \href{#method-ParamSetCollection-subset}{\code{ParamSetCollection$subset()}}
\item \href{#method-ParamSetCollection-clone}{\code{ParamSetCollection$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="add_dep"><a href='../../paradox/html/ParamSet.html#method-ParamSet-add_dep'><code>paradox::ParamSet$add_dep()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="assert"><a href='../../paradox/html/ParamSet.html#method-ParamSet-assert'><code>paradox::ParamSet$assert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="assert_dt"><a href='../../paradox/html/ParamSet.html#method-ParamSet-assert_dt'><code>paradox::ParamSet$assert_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="check"><a href='../../paradox/html/ParamSet.html#method-ParamSet-check'><code>paradox::ParamSet$check()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="check_dt"><a href='../../paradox/html/ParamSet.html#method-ParamSet-check_dt'><code>paradox::ParamSet$check_dt()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="format"><a href='../../paradox/html/ParamSet.html#method-ParamSet-format'><code>paradox::ParamSet$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="get_values"><a href='../../paradox/html/ParamSet.html#method-ParamSet-get_values'><code>paradox::ParamSet$get_values()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="ids"><a href='../../paradox/html/ParamSet.html#method-ParamSet-ids'><code>paradox::ParamSet$ids()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="print"><a href='../../paradox/html/ParamSet.html#method-ParamSet-print'><code>paradox::ParamSet$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="search_space"><a href='../../paradox/html/ParamSet.html#method-ParamSet-search_space'><code>paradox::ParamSet$search_space()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="set_values"><a href='../../paradox/html/ParamSet.html#method-ParamSet-set_values'><code>paradox::ParamSet$set_values()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="test"><a href='../../paradox/html/ParamSet.html#method-ParamSet-test'><code>paradox::ParamSet$test()</code></a></span></li>
<li><span class="pkg-link" data-pkg="paradox" data-topic="ParamSet" data-id="test_dt"><a href='../../paradox/html/ParamSet.html#method-ParamSet-test_dt'><code>paradox::ParamSet$test_dt()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetCollection-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetCollection$new(sets)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sets}}{(\code{list()} of \link{ParamSet})\cr
Parameter objects are cloned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetCollection-add"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetCollection-add}{}}}
\subsection{Method \code{add()}}{
Adds a set to this collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetCollection$add(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{(\link{ParamSet}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetCollection-remove_sets"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetCollection-remove_sets}{}}}
\subsection{Method \code{remove_sets()}}{
Removes sets of given ids from collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetCollection$remove_sets(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character()}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetCollection-subset"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetCollection-subset}{}}}
\subsection{Method \code{subset()}}{
Only included for consistency. Not allowed to perform on \link{ParamSetCollection}s.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetCollection$subset(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{(\code{character()}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParamSetCollection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ParamSetCollection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParamSetCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
