% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformPARAFACloadings.R
\name{transformPARAFACloadings}
\alias{transformPARAFACloadings}
\title{Transform PARAFAC loadings to an orthonormal basis.
Note: this function only works for 3-way PARAFAC models.}
\usage{
transformPARAFACloadings(Fac, modeToCorrect, moreOutput = FALSE)
}
\arguments{
\item{Fac}{Fac object from a PARAFAC object, see \code{\link[=parafac]{parafac()}}.}

\item{modeToCorrect}{Correct the subject (1), feature (2) or time mode (3).}

\item{moreOutput}{Give orthonormal basis and transformation matrices as part of output (default FALSE).}
}
\value{
Corrected loadings of the specified mode.
}
\description{
Transform PARAFAC loadings to an orthonormal basis.
Note: this function only works for 3-way PARAFAC models.
}
\examples{
processedFujita = processDataCube(Fujita2023, sparsityThreshold=0.99, centerMode=1, scaleMode=2)
model = parafac(processedFujita$data, nfac=2, nstart=1, verbose=FALSE)
transformedA = transformPARAFACloadings(model$Fac, 1)
}
