% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_st.R
\name{moment_st}
\alias{moment_st}
\title{Moments of Skew-\eqn{t} Distribution}
\usage{
moment_st(xi = 0, omega = 1, alpha = 0, nu = Inf)
}
\arguments{
\item{xi, omega, alpha, nu}{\link[base]{numeric} scalars or \link[base]{vector}s,
location, scale, slant and degree of freedom parameters of
skew-\eqn{t} distribution}
}
\value{
Function \link{moment_st} returns a \linkS4class{moment} object.
}
\description{
Moments of skew-\eqn{t} distribution, parameter nomenclature follows
\link[sn]{dst} function.
}
\examples{
xi = 2; omega = 1.3; alpha = 3; nu = 6
moment_st(xi, omega, alpha, nu)
curve(sn::dst(x, xi = 2, omega = 1.3, alpha = 3, nu = 6), from = 0, to = 6)

}
\references{
Raw moments of skew-\eqn{t}: \url{https://arxiv.org/abs/0911.2342}
}
