% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_pca_efa.R
\name{get_scores}
\alias{get_scores}
\title{Get Scores from Principal Component or Factor Analysis (PCA/FA)}
\usage{
get_scores(x, n_items = NULL)
}
\arguments{
\item{x}{An object returned by \code{\link[=principal_components]{principal_components()}} or \code{\link[=factor_analysis]{factor_analysis()}}.}

\item{n_items}{Number of required (i.e. non-missing) items to build the sum
score for an observation. If an observation has more missing values than
\code{n_items} in all items of a (sub) scale, \code{NA} is returned for that
observation, else, the sum score of all (sub) items is calculated. If \code{NULL},
the value is chosen to match half of the number of columns in a data frame,
i.e. no more than 50\% missing values are allowed.}
}
\value{
A data frame with subscales, which are average sum scores for all
items from each component or factor.
}
\description{
\code{get_scores()} takes \code{n_items} amount of items that load the most
(either by loading cutoff or number) on a component, and then computes their
average. This results in a sum score for each component from the PCA/FA,
which is on the same scale as the original, single items that were used to
compute the PCA/FA.
}
\details{
\code{get_scores()} takes the results from \code{\link[=principal_components]{principal_components()}} or
\code{\link[=factor_analysis]{factor_analysis()}} and extracts the variables for each component found by
the PCA/FA. Then, for each of these "subscales", row means are calculated
(which equals adding up the single items and dividing by the number of
items). This results in a sum score for each component from the PCA/FA, which
is on the same scale as the original, single items that were used to compute
the PCA/FA.
}
\examples{
\dontshow{if (insight::check_if_installed("psych", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pca <- principal_components(mtcars[, 1:7], n = 2, rotation = "varimax")

# PCA extracted two components
pca

# assignment of items to each component
closest_component(pca)

# now we want to have sum scores for each component
get_scores(pca)

# compare to manually computed sum score for 2nd component, which
# consists of items "hp" and "qsec"
(mtcars$hp + mtcars$qsec) / 2
\dontshow{\}) # examplesIf}
}
\seealso{
Functions to carry out a PCA (\code{\link[=principal_components]{principal_components()}}) or
a FA (\code{\link[=factor_analysis]{factor_analysis()}}). \code{\link[=factor_scores]{factor_scores()}} extracts factor scores
from an FA object.
}
