% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LR.R
\name{LR}
\alias{LR}
\title{Likelihood ratios of pedigree hypotheses}
\usage{
LR(x, ref, markers)
}
\arguments{
\item{x}{A list of pedigrees. Each pedigree is either a single linkdat/singleton object, or a list of such objects 
(the latter is neccessary if the pedigree is disconnected).}

\item{ref}{A single integer, indicating the index of the reference pedigree. This is used in the denominator of each LR.}

\item{markers}{A vector of integers, indexing which markers should be included. If NULL (the default) all markers are used.}
}
\value{
A list with entries
\item{LR}{Likelihood ratios}
\item{LRperMarker}{Likelihood ratios for each marker}
\item{likelihoodsPerSystem}{Likelihoods for each marker}
\item{time}{user, system and elapsed time}
}
\description{
This function computes likelihood ratios for a given a list of pedigrees (linkdat/singletons objects), one of which is
the 'reference', with genotype data from the same set of markers. Data exported from the 'Familias' software can be analysed
by using \code{\link{Familias2linkdat}} prior to calling this function.
}
\examples{

# Simulate genotypes for 5 tetraallelic markers for a pair of full sibs
set.seed(123)
sibs = simpleSim(nuclearPed(2), N=5, alleles=1:4, available=3:4)

# Create two alternative hypotheses and transfer the simulated genotypes to them
halfsibs = addOffspring(nuclearPed(1),father=1,noffs=1,id=4)
halfsibs = transferMarkerdata(sibs, halfsibs)

unrel = list(singleton(3), singleton(4))
unrel = transferMarkerdata(sibs, unrel)

# Compute LR with 'unrelated' as reference
LR(list(sibs, halfsibs, unrel), ref=3)

\dontrun{
data(adoption)
x = Familias2linkdat(adoption$pedigrees, adoption$datamatrix, adoption$loci)
result = LRparamlink(x, ref=2)
result33 = LRparamlink(x, ref=2, marker=c(11,33))
}

}
\seealso{
\code{\link{IBDtriangle}}, \code{\link{examineKinships}}
}
\author{
Magnus Dehli Vigeland and Thore Egeland
}
