% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseaseModel.R
\name{diseaseModel}
\alias{diseaseModel}
\title{Disease models for linkage analysis}
\usage{
diseaseModel(model = NULL, chrom = NULL, penetrances = NULL, dfreq = NULL)
}
\arguments{
\item{model}{An existing \code{disModel} object (to be modified by other
arguments), or one of the following two-letter keywords:
\itemize{
\item \code{AD} = autosomal dominant
\item \code{AR} = autosomal recessive
\item \code{XD} = X-linked dominant
\item \code{XR} = X-linked recessive
}

In all of the above, the disease is assumed to be fully penetrant, and with
a disease allele frequency of 1e-5.}

\item{chrom}{Either "AUTOSOMAL" or "X". Lower case versions are allowed and
will be converted automatically.}

\item{penetrances}{For autosomal models, a numeric of length 3 corresponding
to \verb{(f0, f1, f2)}, where \code{fi} is the probability of being affected given
\code{i} disease alleles. It can also be a matrix with 3 columns, in which case
each row represents a liability class.

For X-linked models, a list of two vectors named \code{male} and \code{female}, of
lengths 2 and 3 respectively: \verb{(f0, f1)} for males and \verb{(f0, f1, f2)} for
females. Alternatively, each list entry may be a matrix or data frame (with
the same number of columns) where each row represents a liability class.}

\item{dfreq}{A number in \verb{[0,1]}: The population frequency of the disease
allele.}
}
\value{
An object of class \code{disModel}, which is a list with entries \code{chrom},
\code{penetrances} and \code{dfreq}.
}
\description{
Create a disease model in form of a \code{disModel} object, for use in e.g.
\code{\link[=lod]{lod()}}.
}
\examples{

# Fully penetrant AD model:
m1 = diseaseModel(model = "AD")

# The above is equivalent to
m2 = diseaseModel(chrom = "Aut", penetrances = c(0,1,1), dfreq = 1e-5)
stopifnot(identical(m1, m2))

# X-linked recessive model:
m3 = diseaseModel(model = "XR", dfreq = 0.01)

# Long version of the above:
m4 = diseaseModel(chrom = "X", penetrances = list(male = c(0,1), female = c(0,0,1)),
              dfreq = 0.01)
stopifnot(identical(m3, m4))

}
\seealso{
\code{\link[=lod]{lod()}}
}
