% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parmsurvfit.R
\docType{data}
\name{oscars}
\alias{oscars}
\title{Data on time until actors receive their first Academy Award nomination}
\format{A data frame with 128 rows and 12 variables:
\describe{
  \item{obs}{observation number}
  \item{name}{name of actor}
  \item{adj_gross}{actor's total adjusted gross earnings (in millions)}
  \item{num_movies}{number of movies actor received credit for}
  \item{avg_gross}{actor's average gross earnings per movie}
  \item{top_movie}{title of actor's movie with the top gross earnings}
  \item{top_gross}{actor's top gross earnings from a single movie}
  \item{gender}{actor's gender}
  \item{years_until_nom}{number of years between actor's first full film appearance and first Oscar nomination}
  \item{censor}{censoring status indicator variable (0 = censored event time, 1 = complete event time)}
  \item{first_film_appearance}{year of actor's first full film appearance}
  \item{first_oscar_nom}{year of actor's first Oscar nomination}
}}
\source{
\url{https://github.com/shannonpileggi/SP--Pablo--RProgramming}
}
\usage{
oscars
}
\description{
The dataset contains data for the top 128 grossing actors up to 2017 as listed on Box Office Mojo.
The data for the first film appearance and for the first Oscar nomination was taken from IMDb.
It should be noted that of the 128 observations in the data set, 48 were right-censored. Right-censored
observations represent actors who have not received an Oscar nomination by the year 2017 or actors that
died before 2017 without ever receiving an Oscar nomination. For the censor variable "1" represents complete
observations, actors who received an Oscar nomination by the year 2017, and "0" represents right-censored
observations.
}
\keyword{datasets}
