% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plotting density function overlayed on top of a histogram of data}
\usage{
plot_density(data, dist, time = "time", censor = "censor", by = "")
}
\arguments{
\item{data}{A dataframe containing a time column and a censor column.}

\item{dist}{A string name for a distribution that has a corresponding density function and distribution function.
Examples include "norm", "lnorm", "exp", "weibull", "logis", "llogis", "gompertz", etc.}

\item{time}{The string name of the time column of the dataframe. Defaults to "time".}

\item{censor}{The string name of the censor column of the dataframe. Defaults to "censor". 
The censor column must be a numeric indicator variable where complete times correspond 
to a value of 1 and incomplete times correspond to 0.}

\item{by}{The string name of a grouping variable. If specified, the function plots each group individually along 
with the plot for all groups together. 
Variable can contain logical, string, character, or numeric data.}
}
\description{
Creates histogram of right censored data with the density function of a fitted parametric distribution overlayed.
}
\examples{
data("rearrest")
plot_density(rearrest, "exp", time = "months")
plot_density(rearrest, "weibull", time = "months", by = "personal")
}
