% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckdb_to_parquet.R
\name{duckdb_to_parquet}
\alias{duckdb_to_parquet}
\title{Convert a duckdb file to parquet format}
\usage{
duckdb_to_parquet(
  path_to_duckdb,
  table_in_duckdb,
  path_to_parquet,
  partition = "no",
  ...
)
}
\arguments{
\item{path_to_duckdb}{string that indicates the path to the duckdb file}

\item{table_in_duckdb}{string that indicates the name of the table to convert in the duckdb file}

\item{path_to_parquet}{string that indicates the path to the directory where the parquet file will be stored}

\item{partition}{string ("yes" or "no" - by default) that indicates whether you want to create a partitioned parquet file.
If "yes", `"partitioning"` argument must be filled in. In this case, a folder will be created for each modality of the variable filled in `"partitioning"`.}

\item{...}{additional format-specific arguments, see \href{https://arrow.apache.org/docs/r/reference/write_parquet.html}{arrow::write_parquet()}
and \href{https://arrow.apache.org/docs/r/reference/write_dataset.html}{arrow::write_dataset()} for more informations.}
}
\value{
A parquet file, invisibly
}
\description{
This function allows to convert a table from a duckdb file to parquet format. \cr
The following extensions are supported : "duckdb" or "db". \cr

Two conversions possibilities are offered :

\itemize{

\item{Convert to a single parquet file. Argument `path_to_parquet` must then be used;}
\item{Convert to a partitioned parquet file. Additionnal arguments `partition` and `partitioning` must then be used;}

}
}
\examples{

# Conversion from a local duckdb file to a single parquet file :

duckdb_to_parquet(
  path_to_duckdb = system.file("extdata","iris.duckdb",package = "parquetize"),
  table_in_duckdb = "iris",
  path_to_parquet = tempdir()
)

# Conversion from a local duckdb file to a partitioned parquet file  :

duckdb_to_parquet(
  path_to_duckdb = system.file("extdata","iris.duckdb",package = "parquetize"),
  table_in_duckdb = "iris",
  path_to_parquet = tempdir(),
  partition = "yes",
  partitioning =  c("Species")
)
}
