% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite_to_parquet.R
\name{sqlite_to_parquet}
\alias{sqlite_to_parquet}
\title{Convert a sqlite file to parquet format}
\usage{
sqlite_to_parquet(
  path_to_sqlite,
  table_in_sqlite,
  path_to_parquet,
  partition = "no",
  ...
)
}
\arguments{
\item{path_to_sqlite}{string that indicates the path to the sqlite file}

\item{table_in_sqlite}{string that indicates the name of the table to convert in the sqlite file}

\item{path_to_parquet}{string that indicates the path to the directory where the parquet file will be stored}

\item{partition}{string ("yes" or "no" - by default) that indicates whether you want to create a partitioned parquet file.
If "yes", `"partitioning"` argument must be filled in. In this case, a folder will be created for each modality of the variable filled in `"partitioning"`.}

\item{...}{additional format-specific arguments, see \href{https://arrow.apache.org/docs/r/reference/write_parquet.html}{arrow::write_parquet()}
and \href{https://arrow.apache.org/docs/r/reference/write_dataset.html}{arrow::write_dataset()} for more informations.}
}
\value{
A parquet file, invisibly
}
\description{
This function allows to convert a table from a sqlite file to parquet format. \cr
The following extensions are supported :
"db","sdb","sqlite","db3","s3db","sqlite3","sl3","db2","s2db","sqlite2","sl2". \cr

Two conversions possibilities are offered :

\itemize{

\item{Convert to a single parquet file. Argument `path_to_parquet` must then be used;}
\item{Convert to a partitioned parquet file. Additionnal arguments `partition` and `partitioning` must then be used;}

}
}
\examples{

# Conversion from a local sqlite file to a single parquet file :

sqlite_to_parquet(
  path_to_sqlite = system.file("extdata","iris.sqlite",package = "parquetize"),
  table_in_sqlite = "iris",
  path_to_parquet = tempdir()
)

# Conversion from a local sqlite file to a partitioned parquet file  :

sqlite_to_parquet(
  path_to_sqlite = system.file("extdata","iris.sqlite",package = "parquetize"),
  table_in_sqlite = "iris",
  path_to_parquet = tempdir(),
  partition = "yes",
  partitioning =  c("Species")
)
}
