\name{FOD}
\alias{FOD}
\alias{FOD.wprof}
\alias{FFOD}
\alias{FFOD.wprof}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fuzzy First Order Domninance analysis through partial orders
}
\description{
The function \code{FOD} provide the Fuzzy First Order Dominance described in Fattore and Arcagni (forthcoming).
}
\usage{
FFOD(profiles, ...)
\method{FFOD}{wprof}(profiles,
    distributions = as.data.frame(profiles$freq),
    lambda = do.call(
        getlambda, as.list(names(profiles$profiles))
    ), ...
)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{profiles}{
	an object of class \code{wprof}.
}
  \item{distributions}{
	a \code{data.frame} of frequencies/weights where the columns correspond to the different distributions and the rows the profiles. The profiles have to be ordered as same as in \code{profiles}.
}
  \item{lambda}{
	object of class \code{incidence} describing a partial order of the importance of the indicators. By default all the indicators are considered incomparable.
}
  \item{\dots}{
any of above.
}
}
\details{
The function requires the profiles structure through the object \code{profiles} of class \code{wprof}. Moreover it is necessary to provide the frequency distributions of the profiles. They can be defined by the argument \code{distributions} of class \code{data.frame}.

Note that the \code{rownames} of the distributions  match the \code{rownamens} of the profiles. If not, a warning is provided that suggest to control if the order of the frequencies correspond to the profiles one.

Through the object \code{lambda} it is possible to define a structure of importance of the indicators that compose the profiles.
}
\value{
An object of class \code{FODposet} containing:
\item{delta}{matrix of the overall dominance degrees.}
\item{mintr.delta}{matrix of the min-transitive fuzzy relation.}
\item{global.approx}{mean relative variation of the min-transitive closure from the dominance degrees.}
\item{global.approx.corr}{mean relative variation of the min-transitive closure from the dominance degrees, corrected without considering the diagonals of the matrices.}
\item{cell.approx}{matrix of absolute variations between the dominance degrees matrix and the min-transitive fuzzy relation.}
\item{posets.ind}{\code{data.frame} to analyse the partial orders generated from the min-transitive fuzzy relation with different alpha-cuts. For each poset are provided: the \code{cardinality}, the number \code{comparabilities}, the number of \code{incomparabilities} and their \code{ci.ratio}.}
\item{eqv.classes}{list of boolean matrices indicating for each alpha-cut how the initial distributions are grouped. Groups are reported by rows and the initial distributions by columns. If the element of the matrix is \code{TRUE} then the distribution of the corresponding column is contained in the group of the corresponding row.}
\item{covers}{list of objects of class \code{cover} representing the cover matrices of the poset generated by each alpha-cut.}
}
\references{
Fattore M., Arcagni A. (forthcoming), F-FOD: Fuzzy First Order Dominance analysis and populations ranking over ordinal multi-indicator systems
}
\author{
Fattore M., Arcagni A.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
v1 <- as.ordered(c("a", "b", "c", "d"))
v2 <- 1:3
prof <- var2prof(varmod = list(v1 = as.ordered(c("a", "b", "c", "d")), v2 = 1:3))
np <- nrow(prof$profiles)

k <- 10 # number of populations
set.seed(0)
populations <- as.data.frame(lapply(1:k, function(x) round(runif(np)*100)))
rownames(populations) <- rownames(prof$profiles)
names(populations) <- paste0("P", 1:k)

prof
populations

res <- FFOD(profiles = prof, distributions = populations)
res
}
