% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors_elements.R
\name{click}
\alias{click}
\title{wrapper around clickElement() method to generate safe scraping code}
\usage{
click(using, value, name = NULL, new_page = FALSE, prev = NULL)
}
\arguments{
\item{using}{character string specifying locator scheme to use to search elements. Available schemes: "class name", "css selector", "id", "name", "link text", "partial link text", "tag name", "xpath".}

\item{value}{character string specifying the search target.}

\item{name}{character string specifying the object name the RSelenium "wElement" class object should be saved to.}

\item{new_page}{logical indicating if clickElement() action will result in a change in url.}

\item{prev}{a placeholder for the output of functions being piped into click(). Defaults to NULL and should not be altered.}
}
\value{
a character string defining 'RSelenium' clicking instructions that can be pasted into a scraping function.
}
\description{
wrapper around clickElement() method to generate safe scraping code
}
\examples{
\dontrun{

#navigate to wikipedia, click random article

parsel::go("https://www.wikipedia.org/") \%>>\%
parsel::click(using = "id", value = "'n-randompage'") \%>>\%
show()

}
}
