% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_force.R
\docType{data}
\name{map_force}
\alias{map_force}
\title{Apply a map to particles}
\description{
In mathematics, maps are a functions that translates its input into new
values. In the context of particles a map is a translation function that
translates the current particle positions to a new one
}
\details{
Normally a map has no notion of velocity — it simply translates positions. In
particles it is possible to decide whether positions should be modified
directly or whether the translation magnitude should be added to the velocity
verlet using the \code{fixed} parameter.
}
\section{Training parameters}{

The following parameters defines the training of the force and can be passed
along a call to \code{\link[=wield]{wield()}}
\itemize{
\item \code{map} : A function that accepts the particle position matrix and returns
the new positions in the same format.
\item \code{fixed} : Logical. Should position be modified directly (\code{TRUE}) or should
the translation be added to the velocity verlet (\code{FALSE})
}
}

\seealso{
Other forces: 
\code{\link{center_force}},
\code{\link{collision_force}},
\code{\link{field_force}},
\code{\link{link_force}},
\code{\link{manybody_force}},
\code{\link{mean_force}},
\code{\link{random_force}},
\code{\link{reset_force}},
\code{\link{trap_force}},
\code{\link{x_force}},
\code{\link{y_force}}
}
\concept{forces}
\keyword{datasets}
