% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_lat_lon.R
\name{parse_lon_lat}
\alias{parse_lon_lat}
\title{parse longitude and latitude}
\usage{
parse_lon_lat(lon, lat)
}
\arguments{
\item{lon}{(character/numeric/integer) one or more longitude values}

\item{lat}{(character/numeric/integer) one or more latitude values}
}
\value{
data.frame, with columns lon, lat. on an invalid values, an \code{NA}
is returned. In addition, warnings are thrown on invalid values
}
\description{
parse longitude and latitude
}
\details{
length(lon) == length(lat)
}
\examples{
parse_lon_lat(-120.43, 49.12)
\dontrun{
parse_lon_lat(-120.43, 93)
parse_lon_lat(-190, 49.12)
parse_lon_lat(240, 49.12)
parse_lon_lat(-190, 92)
# many
lons <- c("45W54.2356", "181", 45, 45.234234, "-45.98739874")
lats <- c("40.123°", "40.123N74.123W", "191.89", 12, "N45 04.25764")
parse_lon_lat(lons, lats)
}
}
