% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_format.R
\name{order_countries}
\alias{order_countries}
\title{Order a vector of countries}
\usage{
order_countries(x, by, ..., from = "iso2c", short = TRUE, variant = FALSE,
  factor = is.factor(x))
}
\arguments{
\item{x}{A character, factor, or numeric vector of country codes or names}

\item{by}{Either a length-one country code from \code{\link{codes}} or a vector the
same length as \code{x} by which to order \code{x}}

\item{...}{Parameters passed on to \code{\link[=order]{order()}}, including addition vectors by
which to sort, \code{decreasing}, and \code{na.last}.}

\item{from}{Code format from which to convert. Defaults to \code{"iso2c"};
see \code{\link{codes}} for more options.}

\item{short}{Whether to use short alternative name when available. Can be
length 1 or the same length as \code{x}.}

\item{variant}{Whether to use variant alternative name when available. Can
be length 1 or the same length as \code{x}.}

\item{factor}{If \code{TRUE}, returns factor instead of character vector. If not
supplied, defaults to \code{is.factor(x)}}
}
\value{
The original vector of countries, ordered according to the parameters
passed. Note that factors are not releveled, but are reordered. To
relevel, pass the results to \code{\link[=levels<-]{levels<-()}}
}
\description{
\code{order_countries} reorders a vector of countries, returning a result useful
for passing to ggplot2's scale functions' \code{limits} parameters.
}
\details{
\code{order_countries} orders a vector of countries by
\itemize{
\item itself converted to a country code or name if \code{by} is a code from \code{\link{codes}}
to which to convert
\item a sortable vector if \code{by} is a vector of the same length as \code{x}
\item \code{x} itself if neither is supplied.
}
}
\examples{
countries <- c("FR", "CP", "UZ", "BH", "BR")

order_countries(countries)

order_countries(countries, "ja")

order_countries(countries, rnorm(5))

order_countries(countries, grepl("F", countries), 1:5, decreasing = TRUE)

if (require(ggplot2, quietly = TRUE)) {
    df_countries <- data.frame(country = countries,
                               y = exp(1:5))

    ggplot(df_countries, aes(country, y)) +
        geom_col() +
        scale_x_discrete(
            limits = order_countries(df_countries$country,
                                     df_countries$y)[df_countries$y > 5],
            labels = country_format(to = "en-cia-local")
        )
}

}
\seealso{
To change labels of a discrete scale, pass the results of
\code{\link[=country_format]{country_format()}} to the \code{labels} parameter.
}
