% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{choose_clusters}
\alias{choose_clusters}
\title{Cluster Pathways and Dynamically Cut the Dendrogram}
\usage{
choose_clusters(result_df, ...)
}
\arguments{
\item{result_df}{resulting data frame of enriched pathways from the wrapper
  function \code{run_pathfindR}. Columns are: \enumerate{
  \item{ID: }{KEGG ID of the enriched pathway}
  \item{Pathway: }{Description of the enriched pathway}
  \item{occurrence: }{the number of iterations that the given pathway was found to be enriched over all iterations}
  \item{lowest_p: }{the lowest adjusted-p value of the given pathway over all iterations}
  \item{highest_p: }{the highest adjusted-p value of the given pathway over all iterations}
  \item{Up_regulated: }{the up-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Down_regulated: }{the down-regulated genes in the input involved in the given pathway, comma-separated}
}}

\item{...}{optional arguments for \code{cluster_pathways}}
}
\value{
This function first calculates the pairwise distances between the
  pathways in the \code{result_df} data frame. Via a shiny HTML document, the
  hierarchical clustering dendrogram is visualized. In this HTML document,
  the user can select the agglomeration method and the distance value at
  which to cut the tree. The resulting cluster assignments of the pathways
  along with annotation of representative pathways (chosen by smallest lowest
  p value) are presented as a table and this table can be saved as a csv
  file.
}
\description{
See "Chen, Y. A. et al. Integrated pathway clusters with coherent biological
themes for target prioritisation. PLoS One 9, e99030,
doi:10.1371/journal.pone.0099030 (2014)." for details on the method of
pathway clustering.
}
\examples{
\dontrun{
choose_clusters(RA_output)
}
}
\seealso{
See \code{\link{cluster_pathways}} for calculation of pairwise
  distances between enriched pathways. See \code{\link{run_pathfindR}}
  for the wrapper function of the pathfindR enrichment workflow.
}
