/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchAlgorithms;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchAlgorithms.CrossoverType;
import ActiveSubnetworkSearchAlgorithms.GAIndividual;
import ActiveSubnetworkSearchAlgorithms.NewPopulationFactory;
import ActiveSubnetworkSearchAlgorithms.SelectionType;
import ActiveSubnetworkSearchMisc.ScoreCalculations;
import ActiveSubnetworkSearchMisc.Subnetwork;
import Application.Parameters;
import Network.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeneticAlgorithm {
    ScoreCalculations scoreCalculations;
    ArrayList<Node> networkNodeList;
    Random random;
    int populationSize;

    public ArrayList<Subnetwork> geneticAlgorithm() {
        this.scoreCalculations = ActiveSubnetworkSearch.scoreCalculations;
        this.networkNodeList = ActiveSubnetworkSearch.networkNodeList;
        this.populationSize = Parameters.ga_populationSize;
        ArrayList<GAIndividual> population = new ArrayList<GAIndividual>();
        this.random = new Random(Parameters.seedForRandom);
        this.initializePopulation(population, this.populationSize);
        this.printSituation(population);
        int addRandomIndividualCount = 0;
        boolean running = true;
        int iter = 0;
        GAIndividual lastBestIndividual = population.get(0);
        int lastBestRepeatNumber = 0;
        while (running) {
            ArrayList<GAIndividual> newPopulation = this.createNewPopulation(population, SelectionType.RANKSELECTION, CrossoverType.UNIFORM);
            if (addRandomIndividualCount == 10) {
                int i = 1;
                while ((double)i <= (double)Parameters.ga_populationSize * 0.1) {
                    newPopulation.set(newPopulation.size() - i, this.createRandomGAIndividual());
                    ++i;
                }
                addRandomIndividualCount = 0;
            }
            if (Parameters.ga_Elitism && newPopulation.get(0).compareTo(population.get(0)) < 0) {
                newPopulation.set(newPopulation.size() - 1, population.get(0));
            }
            Collections.sort(newPopulation, Collections.reverseOrder());
            population = newPopulation;
            System.out.println("New Population, iter=" + iter);
            this.printSituation(population);
            ++addRandomIndividualCount;
            ++iter;
            if (population.get(0).compareTo(lastBestIndividual) == 0) {
                ++lastBestRepeatNumber;
            } else {
                lastBestIndividual = population.get(0);
                lastBestRepeatNumber = 0;
            }
            if (lastBestRepeatNumber >= 50) {
                running = false;
                System.out.println("The score did not improve in 50 steps");
            }
            if (iter < Parameters.ga_totalIterations) continue;
            running = false;
        }
        return population.get(0).getSubnetworkList();
    }

    private void printSituation(ArrayList<GAIndividual> population) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(population.get(i).toString());
        }
    }

    private void initializePopulation(ArrayList<GAIndividual> population, int populationSize) {
        for (int i = 0; i < populationSize; ++i) {
            population.add(this.createRandomGAIndividual());
        }
        if (Parameters.startWithAllPositiveZScoreNodes) {
            ArrayList<Boolean> individualPositiveZ = new ArrayList<Boolean>();
            for (int i = 0; i < this.networkNodeList.size(); ++i) {
                Node node = this.networkNodeList.get(i);
                individualPositiveZ.add(this.scoreCalculations.getZScore(node) > 0.0);
            }
            population.set(populationSize - 1, new GAIndividual(individualPositiveZ));
        }
        Collections.sort(population, Collections.reverseOrder());
    }

    private GAIndividual createRandomGAIndividual() {
        ArrayList<Boolean> individual = new ArrayList<Boolean>();
        for (int i = 0; i < this.networkNodeList.size(); ++i) {
            individual.add(this.random.nextDouble() < Parameters.geneInitialAdditionProbability);
        }
        return new GAIndividual(individual);
    }

    private ArrayList<GAIndividual> createNewPopulation(ArrayList<GAIndividual> population, SelectionType selectionType, CrossoverType crossoverType) {
        ArrayList<GAIndividual> newPopulation = new ArrayList<GAIndividual>();
        long start = System.nanoTime();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < Parameters.ga_threadNumber; ++i) {
            Thread thread = new Thread(new NewPopulationFactory(population, newPopulation, selectionType, crossoverType));
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(GeneticAlgorithm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        long stop = System.nanoTime();
        System.out.println("Time:" + (stop - start) / 1000000L);
        Collections.sort(newPopulation, Collections.reverseOrder());
        return newPopulation;
    }
}

