% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Path-class.R
\name{\%//\%}
\alias{\%//\%}
\title{Join two paths}
\usage{
lhs \%//\% rhs
}
\arguments{
\item{lhs}{the path component(s) to be joined on lhs}

\item{rhs}{path components(s) to be joined on rhs}
}
\value{
a new \code{Path} object (or vector of) corresponding to the joined
elements
}
\description{
Join two path components in the "natural" way, as you would expect to
using a \code{/} operator. \code{lhs} and \code{rhs} may be any object that implements
the \code{as.character} S3 method, including \code{Path}
}
\examples{
path <- Path$new("root/parent/name")
child <- path \%//\% "child"
print(glue::glue("path : {path$show}",
                 "child: {child$show}",
                 .sep = "\\n"))
}
\seealso{
Other Path: \code{\link{Path$..}}, \code{\link{Path$.}},
  \code{\link{Path$dir}}, \code{\link{Path$join}},
  \code{\link{Path$name}}, \code{\link{Path$new}},
  \code{\link{Path$parent}}, \code{\link{Path$show}},
  \code{\link{Path}}
}
\concept{Path}
