% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_createSubjectProfileReport.R
\name{sortSubjects}
\alias{sortSubjects}
\title{Sort subjects based on a specified dataset/variable.}
\usage{
sortSubjects(
  subjects,
  subjectVar = "USUBJID",
  subjectSortData = NULL,
  subjectSortVar = NULL,
  subjectSortDecreasing = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{subjects}{Character vector with subjects of interest}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{subjectSortData}{Data.frame with data containing information on how the subjects 
should be sorted.}

\item{subjectSortVar}{Variable(s) of \code{subjectSortData} 
used to order the subjects}

\item{subjectSortDecreasing}{Logical, if TRUE (FALSE by default)
subjects are sorted based on inverse order of \code{subjectSortVar}.}

\item{verbose}{logical, if TRUE print messages during execution}
}
\value{
Updated \code{subjects}
}
\description{
Sort subjects based on a specified dataset/variable.
}
\author{
Laure Cougnaud
}
