% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{formatTimeLim}
\alias{formatTimeLim}
\title{Format specified \code{timeLim}.}
\usage{
formatTimeLim(
  data,
  subjectVar = "USUBJID",
  timeStartVar,
  timeEndVar,
  timeLim = NULL
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{timeStartVar}{String, variable of \code{data} 
with start of time interval.}

\item{timeEndVar}{String, variable of \code{data} 
with end of time interval.}

\item{timeLim}{(optional) Vector of length 2 with time limits (x-axis).
If not specified, these are extracted from the minimum \code{timeStartVar} 
and maximum \code{timeEndVar} per subject.\cr
The time limits are stored as attributes of the plots,
used to align the plots in the final report.}
}
\value{
Numeric vector of length 2 or list of such element
for each subject.
}
\description{
In case one of the limits if missing,
the corresponding minimum/maximum across subjects is used.
}
\author{
Laure Cougnaud
}
