% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternbar_s.R
\name{patternbar_s}
\alias{patternbar_s}
\title{Plot a stacked bar chart using patterns and colors to fill the bars.}
\usage{
patternbar_s(data, x, y, group, xlab = "", ylab = "",
  label.size = 3.5, pattern.type, pattern.line.size = rep(10,
  length(unique(group))), pattern.color = rep("black",
  length(unique(group))), background.color = rep("white",
  length(unique(group))), frame.color = "black", frame.size = 1,
  pixel = 20, density = rep(12, length(unique(group))),
  legend.type = "h", legend.h = 6, legend.x.pos = 1.1,
  legend.y.pos = 0.49, legend.w = 0.2, legend.pixel = 20,
  bar.width = 0.9)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{label.size}{the font size of legend labels shown above the bars.}

\item{pattern.type}{a vector of patterns to be filled in the bars 
The pattern types include: 'blank', 'bricks', 'vdashes', 'hdashes', 'crosshatch','dots', 
'grid','hlines','nelines', 'nwlines', 'vlines', 'waves' and more.}

\item{pattern.line.size}{a vector of numeric values, the line size for the lines/dots of patterns.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the bars.}

\item{frame.color}{the color for the borders of bars.}

\item{frame.size}{a numeric value, the line size for the borders of bars.}

\item{pixel}{a numeric value, the pixel resolution of bar chart.}

\item{density}{a numeric vector, the density for the lines/dots of patterns.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal; if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.x.pos}{a numeric value to change the position of legends on x axis.}

\item{legend.y.pos}{a numeric value to change the position of legends on y axis.}

\item{legend.w}{a numeric value to change the width of legends.}

\item{legend.pixel}{a numeric value to change pixel of legends.}

\item{bar.width}{a numeric value to change the width of the bars.}
}
\value{
A ggplot object.
}
\description{
The \code{patternbar_s} function is a tool for creating versatile stacked bar charts 
by filling the bars with colors and patterns.
}
\details{
\code{patternbar_s} function offers flexible ways of doing stacked bar charts.
}
\examples{
#Example 1
library(patternplot)
library(png)
library(ggplot2)
data <- read.csv(system.file("extdata", "monthlyexp.csv", package="patternplot"))
x<-data$Location
y<-data$Amount
group<-data$Type

patternbar_s(data,x, y, group,xlab='', ylab='Monthly Expenses, Dollar', label.size=3.5,
pattern.type=c('Unicode_\\u266B', 'nwlines', 'bricks'),pattern.line.size=c(10, 5, 5),frame.size=1,
pattern.color=c('blue', 'green', 'white'),background.color=c('white', 'white', 'orange'),pixel=20, 
density=c(10, 10, 10),frame.color='black', legend.type='h', legend.h=10, legend.y.pos=0.49,
legend.pixel=10, legend.w=0.25, legend.x.pos=1.1)+scale_y_continuous(limits = c(0, 6800))

}
\seealso{
Function \code{imagebar_s}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
