% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sensmodel.R
\name{sensmodel}
\alias{sensmodel}
\title{Modelling spectral sensitivity}
\usage{
sensmodel(peaksense, range = c(300, 700), lambdacut = NULL, Bmid = NULL,
  oiltype = NULL, beta = TRUE, om = NULL, integrate = TRUE)
}
\arguments{
\item{peaksense}{(required) a vector with peak sensitivities for the cones to
model}

\item{range}{a vector of length 2 for the range over which to calculate the spectral
sensitivities (defaults to 300nm to 700nm)}

\item{lambdacut}{a vector of same length as peaksense that lists the cut-off wavelength
value for oil droplets. Needs either \code{Bmid} or \code{oiltype} to also be entered.
See Hart and Vorobyev (2005)}

\item{Bmid}{a vector of same length as peaksense that lists the gradient of line
tangent to the absorbance spectrum of the oil droplets. See Hart and Vorobyev (2005)}

\item{oiltype}{a list of same length as peaksense that lists the oil droplet types
(currently accepts only "T", C", "Y", "R", "P") when Bmid is not known. Calculates
Bmid based on the regression equations found in Hart ad Vorobyev (2005).}

\item{beta}{logical. If \code{TRUE} the sensitivities will include the beta peak
See Govardovskii et al.(2000) (defaults to \code{TRUE}).}

\item{om}{a vector of same length as \code{range1}-\code{range2} that contains ocular media transmission data.
If included, cone sensitivity will be corrected for ocular media transmission. Currently accepts "bird" using
values from Hart et al. (2005), or user-defined values.}

\item{integrate}{logical. If \code{TRUE}, each curve is transformed to have a total area
under the curve of 1 (best for visual models; defaults to \code{TRUE}).}
}
\value{
A data frame of class \code{rspec} containing each cone model as a column.
}
\description{
Models spectral sensitivity (with oil droplets; optional) based on peak cone sensitivity
according to the models of Govardovskii et al. (2000) and Hart & Vorobyev (2005).
}
\examples{
\dontrun{
# Blue tit visual system based on Hart et al (2000)
bluesens <- sensmodel(c(371,448,502,563),beta=F,oiltype = c("T", "C", "Y","R"),om= TRUE)
# Danio aequipinnatus based on Govardovskii et al. (2000)
daniosens <- sensmodel(c(357,411,477,569))}
}
\author{
Pierre-Paul Bitton \email{bittonp@uwindsor.ca}, Chad Eliason \email{cme16@zips.uakron.edu}
}
\references{
Govardovskii VI, Fyhrquist N, Reuter T, Kuzmin DG and Donner K. 2000. In search of the visual pigment template. Visual Neuroscience 17:509-528

Hart NS, and Vorobyev M. 2005. Modelling oil droplet absorption
spectra and spectral sensitivities of bird cone photoreceptors. Journal of
Comparative Physiology A. 191: 381-392

Hart NS, Partridge JC, Cuthill IC, Bennett AT (2000) Visual pigments, oil droplets, ocular media and cone photoreceptor
distribution in two species of passerine bird: the blue tit (Parus caeruleus L) and the blackbird (Turdus merula L). J Comp
Physiol A 186:375-387
}

