% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcsplot.R, R/tcspoints.R, R/tcsvol.R
\name{tcsplot}
\alias{tcsplot}
\alias{tcspoints}
\alias{tcsvol}
\title{Interactive plot of a tetrahedral colorspace}
\usage{
tcsplot(tcsdata, size = 0.02, alpha = 1, col = "black",
  vertexsize = 0.02, achro = TRUE, achrosize = 0.01, achrocol = "grey",
  lwd = 1, lcol = "lightgrey", new = FALSE, hspin = FALSE,
  vspin = FALSE, floor = TRUE, grid = TRUE, fill = TRUE)

tcspoints(tcsdata, size = 0.02, col = "black", alpha = 1)

tcsvol(tcsdata, col = "black", alpha = 0.2, grid.alpha = 1, grid = T,
  fill = T, lwd = 1)
}
\arguments{
\item{tcsdata}{(required) a data frame, possibly a result from the \code{colspace} 
function, containing values for the 'x', 'y' and 'z' coordinates as columns (labeled as such)}

\item{size}{size of the points in the plot (defaults to 0.02)}

\item{alpha}{transparency of points (or volume fill in \code{tcsvol})}

\item{col}{color of the points in the plot (defaults to black)}

\item{vertexsize}{size of the points at the vertices}

\item{achro}{plot a point at the origin? (defaults to \code{TRUE})}

\item{achrosize}{size of the point in the achromatic center}

\item{achrocol}{color of the point in the achromatic center}

\item{lwd, lcol}{graphical parameters for the edges of the tetrahedron.}

\item{new}{should a new 3D plot be called (defaults to \code{FALSE})?}

\item{hspin}{if \code{TRUE}, the graphic will spin horizontally (around the 'z' axis)(defaults to \code{FALSE})}

\item{vspin}{if \code{TRUE}, the graphic will spin vertically (around the 'x' axis)(defaults to \code{FALSE})}

\item{floor}{if \code{TRUE}, a reference xy plane is plotted under the tetrahedron (defaults to \code{TRUE})}

\item{grid}{if \code{TRUE}, connects the polygon outlining the volume occupied by points (defaults to \code{TRUE})}

\item{fill}{if \code{TRUE}, fills the volume occupied by points (WARNING: transparency
is not saved properly if exported using \code{rgl.postscript})(defaults to \code{TRUE}).}

\item{grid.alpha}{transparecny of the volume polygon grid lines}
}
\value{
\code{tcsplot} creates a 3D plot using functions of the package \code{rgl}, 
based on openGL capabilities. Plot is interactive and can be manipulated with the mouse 
(left button: rotate along 'z' axis; right button: rotate along 'x' axis; 
third button: zoom). \code{tcsvol} creates polygon based on points, determining the volume
occupied by them in the colorspace. \code{tcspoints} adds points to the plot. Points are
currently plotted only as spheres to maintain export capabilities.

\code{tcspoints} creates 3D points in a tetrahedral color space plot produced by \code{tcsplot}
using functions of the package \code{rgl}, based on openGL capabilities.

\code{tcsvol} creates a 3D convex hull within a \code{tcsplot} object.
}
\description{
Produces an interactive 3D plot of a tetrahedral 
colorspace using OpenGL capabilities.

Plots points in a tetrahedral color space

Produces a 3D convex hull in tetrahedral color space
}
\examples{
\dontrun{
# For plotting
data(sicalis)
vis.sicalis <- vismodel(sicalis, visual = 'avg.uv')
tcs.sicalis <- colspace(vis.sicalis, space = 'tcs')
plot(tcs.sicalis, size = 0.005)
rgl.postscript('testplot.pdf',fmt='pdf') 
rgl.snapshot('testplot.png')

# For adding points
patch <- rep(c('C', 'T', 'B'), 7)
tcs.crown <- subset(tcs.sicalis, 'C') 
tcs.breast <- subset(tcs.sicalis, 'B') 
plot(tcs.crown, col ='blue')
points(tcs.breast, col ='red')

# For plotting convex hull
plot(tcs.sicalis, col = 'blue', size = 0.005)
vol(tcs.sicalis)
}

}
\references{
Stoddard, M. C., & Prum, R. O. (2008). Evolution of avian plumage 
 color in a tetrahedral color space: A phylogenetic analysis of new world buntings. 
 The American Naturalist, 171(6), 755-776.

Endler, J. A., & Mielke, P. (2005). Comparing entire colour patterns 
 as birds see them. Biological Journal Of The Linnean Society, 86(4), 405-431.
}
\seealso{
\code{\link[rgl]{spheres3d}},\code{\link[rgl]{rgl.postscript}}, 
\code{\link[rgl]{rgl.snapshot}},\code{\link[rgl]{rgl.material}}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
