% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rspec.R
\name{as.rspec}
\alias{as.rspec}
\alias{is.rspec}
\title{Convert data to an rspec object}
\usage{
as.rspec(object, whichwl = NULL, interp = TRUE, lim = NULL,
  exceed.range = TRUE)

is.rspec(object)
}
\arguments{
\item{object}{(required) a data frame or matrix containing spectra to
process.}

\item{whichwl}{a numeric or character vector specifying which column contains
wavelengths. If NULL (default), function searches for column containing equally
spaced numbers and sets it as wavelengths "wl". If no wavelengths are found or
\code{whichwl} is not given, returns arbitrary index values.}

\item{interp}{whether to interpolate wavelengths in 1-nm bins (defaults to
TRUE).}

\item{lim}{vector specifying wavelength range to interpolate over (e.g.
\code{c(300, 700)}).}

\item{exceed.range}{logical. Should data be interpolated to the limits specified
by \code{lim} if \code{lim} exceeds the range of the actual data? Useful, and relatively safe,
when the data range falls slightly within \code{lim} (e.g. 300.1 - 699 nm), but will
produce spurious results if \code{lim} far exceeds the range of input data.
Defaults to \code{TRUE}.}
}
\value{
an object of class \code{rspec} for use in further \code{pavo}
functions

a logical value indicating whether the object is of class
\code{rspec}
}
\description{
Converts data frames or matrices containing spectral data to \code{rspec}
object
}
\examples{

# Generate some fake reflectance data
fakedat <- data.frame(wl = 300:700, refl1 = rnorm(401), refl2 = rnorm(401))
head(fakedat)

# Determine if is rspec object
is.rspec(fakedat)

# Convert to rspec object
fakedat2 <- as.rspec(fakedat)
is.rspec(fakedat2)
head(fakedat2)
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}
}
