% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triplot.R
\name{triplot}
\alias{triplot}
\title{Plot a Maxwell triangle}
\usage{
triplot(
  tridata,
  labels = TRUE,
  achro = TRUE,
  achrocol = "grey",
  achrosize = 0.8,
  labels.cex = 1,
  out.lwd = 1,
  out.lcol = "black",
  out.lty = 1,
  square = TRUE,
  gamut = FALSE,
  margins = NULL,
  ...
)
}
\arguments{
\item{tridata}{(required) a data frame, possibly a result from the
\code{\link[=colspace]{colspace()}} or \code{\link[=trispace]{trispace()}} function, containing values for the 'x' and
'y' coordinates as columns (labeled as such).}

\item{labels}{logical. Should the name of each cone be printed next to the
corresponding vertex?}

\item{achro}{should a point be plotted at the origin (defaults to \code{TRUE})?}

\item{achrocol}{color of the point at the origin \code{achro = TRUE} (defaults to
\code{'grey'}).}

\item{achrosize}{size of the point at the origin when \code{achro = TRUE}
(defaults to \code{0.8}).}

\item{labels.cex}{size of the arrow labels.}

\item{out.lwd, out.lcol, out.lty}{graphical parameters for the plot outline.}

\item{square}{logical. Should the aspect ratio of the plot be held to 1:1?
(defaults to \code{TRUE}).}

\item{gamut}{logical. Should the polygon showing the possible colours given
visual system and illuminant used in the analysis (defaults to \code{FALSE}).
This option currently only works when \code{qcatch = Qi}.}

\item{margins}{Deprecated. Please use the standard \code{\link[=par]{par()}} method for custom margins.}

\item{...}{additional graphical options. See \code{\link[=par]{par()}}.}
}
\description{
Produces a Maxwell triangle plot.
}
\examples{
data(flowers)
vis.flowers <- vismodel(flowers, visual = "apis")
tri.flowers <- colspace(vis.flowers, space = "tri")
plot(tri.flowers)
}
\references{
Maxwell JC. (1970). On color vision. In: Macadam, D. L. (ed)
Sources of Color Science. Cambridge, MIT Press, 1872 - 1873.

Kelber A, Vorobyev M, Osorio D. (2003). Animal colour vision -
behavioural tests and physiological concepts. Biological Reviews, 78,
81 - 118.

MacLeod DIA, Boynton RM. (1979). Chromaticity diagram showing
cone excitation by stimuli of equal luminance. Journal of the Optical
Society of America, 69, 1183-1186.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
