# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include kafka_service.R
NULL

#' Creates a new MSK cluster
#'
#' Creates a new MSK cluster.
#'
#' @usage
#' kafka_create_cluster(BrokerNodeGroupInfo, ClusterName, EncryptionInfo,
#'   EnhancedMonitoring, KafkaVersion, NumberOfBrokerNodes)
#'
#' @param BrokerNodeGroupInfo &#91;required&#93; Information about the broker nodes in the cluster.
#' @param ClusterName &#91;required&#93; The name of the cluster.
#' @param EncryptionInfo Includes all encryption-related information.
#' @param EnhancedMonitoring Specifies the level of monitoring for the MSK cluster. The possible
#' values are DEFAULT, PER\\_BROKER, and PER\\_TOPIC\\_PER\\_BROKER.
#' @param KafkaVersion &#91;required&#93; The version of Apache Kafka.
#' @param NumberOfBrokerNodes &#91;required&#93; The number of Kafka broker nodes in the Amazon MSK cluster.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster(
#'   BrokerNodeGroupInfo = list(
#'     BrokerAZDistribution = "DEFAULT",
#'     ClientSubnets = list(
#'       "string"
#'     ),
#'     InstanceType = "string",
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     StorageInfo = list(
#'       EbsStorageInfo = list(
#'         VolumeSize = 123
#'       )
#'     )
#'   ),
#'   ClusterName = "string",
#'   EncryptionInfo = list(
#'     EncryptionAtRest = list(
#'       DataVolumeKMSKeyId = "string"
#'     )
#'   ),
#'   EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER",
#'   KafkaVersion = "string",
#'   NumberOfBrokerNodes = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_create_cluster
kafka_create_cluster <- function(BrokerNodeGroupInfo, ClusterName, EncryptionInfo = NULL, EnhancedMonitoring = NULL, KafkaVersion, NumberOfBrokerNodes) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/v1/clusters",
    paginator = list()
  )
  input <- .kafka$create_cluster_input(BrokerNodeGroupInfo = BrokerNodeGroupInfo, ClusterName = ClusterName, EncryptionInfo = EncryptionInfo, EnhancedMonitoring = EnhancedMonitoring, KafkaVersion = KafkaVersion, NumberOfBrokerNodes = NumberOfBrokerNodes)
  output <- .kafka$create_cluster_output()
  svc <- .kafka$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_cluster <- kafka_create_cluster

#' Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in
#' the request
#'
#' Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in
#' the request.
#'
#' @usage
#' kafka_delete_cluster(ClusterArn, CurrentVersion)
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion The current version of the MSK cluster.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster(
#'   ClusterArn = "string",
#'   CurrentVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_delete_cluster
kafka_delete_cluster <- function(ClusterArn, CurrentVersion = NULL) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/v1/clusters/{clusterArn}",
    paginator = list()
  )
  input <- .kafka$delete_cluster_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion)
  output <- .kafka$delete_cluster_output()
  svc <- .kafka$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_cluster <- kafka_delete_cluster

#' Returns a description of the MSK cluster whose Amazon Resource Name
#' (ARN) is specified in the request
#'
#' Returns a description of the MSK cluster whose Amazon Resource Name
#' (ARN) is specified in the request.
#'
#' @usage
#' kafka_describe_cluster(ClusterArn)
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster(
#'   ClusterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster
kafka_describe_cluster <- function(ClusterArn) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}",
    paginator = list()
  )
  input <- .kafka$describe_cluster_input(ClusterArn = ClusterArn)
  output <- .kafka$describe_cluster_output()
  svc <- .kafka$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster <- kafka_describe_cluster

#' A list of brokers that a client application can use to bootstrap
#'
#' A list of brokers that a client application can use to bootstrap.
#'
#' @usage
#' kafka_get_bootstrap_brokers(ClusterArn)
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#'
#' @section Request syntax:
#' ```
#' svc$get_bootstrap_brokers(
#'   ClusterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_get_bootstrap_brokers
kafka_get_bootstrap_brokers <- function(ClusterArn) {
  op <- new_operation(
    name = "GetBootstrapBrokers",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/bootstrap-brokers",
    paginator = list()
  )
  input <- .kafka$get_bootstrap_brokers_input(ClusterArn = ClusterArn)
  output <- .kafka$get_bootstrap_brokers_output()
  svc <- .kafka$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$get_bootstrap_brokers <- kafka_get_bootstrap_brokers

#' Returns a list of clusters in an account
#'
#' Returns a list of clusters in an account.
#'
#' @usage
#' kafka_list_clusters(ClusterNameFilter, MaxResults, NextToken)
#'
#' @param ClusterNameFilter Specify a prefix of the name of the clusters that you want to list. The
#' service lists all the clusters whose names start with this prefix.
#' @param MaxResults The maximum number of clusters to return in the response. If there are
#' more clusters, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of a ListClusters
#' operation is truncated, the call returns NextToken in the response. To
#' get another batch of clusters, provide this token in your next request.
#'
#' @section Request syntax:
#' ```
#' svc$list_clusters(
#'   ClusterNameFilter = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_clusters
kafka_list_clusters <- function(ClusterNameFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/v1/clusters",
    paginator = list()
  )
  input <- .kafka$list_clusters_input(ClusterNameFilter = ClusterNameFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_clusters_output()
  svc <- .kafka$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_clusters <- kafka_list_clusters

#' Returns a list of the broker nodes in the cluster
#'
#' Returns a list of the broker nodes in the cluster.
#'
#' @usage
#' kafka_list_nodes(ClusterArn, MaxResults, NextToken)
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param MaxResults The maximum number of clusters to return in the response. If there are
#' more clusters, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of a ListClusters
#' operation is truncated, the call returns NextToken in the response. To
#' get another batch of clusters, provide this token in your next request.
#'
#' @section Request syntax:
#' ```
#' svc$list_nodes(
#'   ClusterArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kafka_list_nodes
kafka_list_nodes <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListNodes",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/nodes",
    paginator = list()
  )
  input <- .kafka$list_nodes_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_nodes_output()
  svc <- .kafka$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_nodes <- kafka_list_nodes
