% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_add_tags}
\alias{emr_add_tags}
\title{Adds tags to an Amazon EMR resource}
\usage{
emr_add_tags(ResourceId, Tags)
}
\arguments{
\item{ResourceId}{[required] The Amazon EMR resource identifier to which tags will be added. This
value must be a cluster identifier.}

\item{Tags}{[required] A list of tags to associate with a cluster and propagate to EC2
instances. Tags are user-defined key/value pairs that consist of a
required key string with a maximum of 128 characters, and an optional
value string with a maximum of 256 characters.}
}
\description{
Adds tags to an Amazon EMR resource. Tags make it easier to associate
clusters in various ways, such as grouping clusters to track your Amazon
EMR resource allocation costs. For more information, see \href{http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html}{Tag Clusters}.
}
\section{Request syntax}{
\preformatted{svc$add_tags(
  ResourceId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
