% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_list_clusters}
\alias{kafka_list_clusters}
\title{Returns a list of clusters in an account}
\usage{
kafka_list_clusters(ClusterNameFilter, MaxResults, NextToken)
}
\arguments{
\item{ClusterNameFilter}{Specify a prefix of the name of the clusters that you want to list. The
service lists all the clusters whose names start with this prefix.}

\item{MaxResults}{The maximum number of clusters to return in the response. If there are
more clusters, the response includes a NextToken parameter.}

\item{NextToken}{The paginated results marker. When the result of a ListClusters
operation is truncated, the call returns NextToken in the response. To
get another batch of clusters, provide this token in your next request.}
}
\description{
Returns a list of clusters in an account.
}
\section{Request syntax}{
\preformatted{svc$list_clusters(
  ClusterNameFilter = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
