% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_delete_application_reference_data_source}
\alias{kinesisanalytics_delete_application_reference_data_source}
\title{Deletes a reference data source configuration from the specified
application configuration}
\usage{
kinesisanalytics_delete_application_reference_data_source(
  ApplicationName, CurrentApplicationVersionId, ReferenceId)
}
\arguments{
\item{ApplicationName}{[required] Name of an existing application.}

\item{CurrentApplicationVersionId}{[required] Version of the application. You can use the DescribeApplication
operation to get the current application version. If the version
specified is not the current version, the
\code{ConcurrentModificationException} is returned.}

\item{ReferenceId}{[required] ID of the reference data source. When you add a reference data source to
your application using the AddApplicationReferenceDataSource, Amazon
Kinesis Analytics assigns an ID. You can use the DescribeApplication
operation to get the reference ID.}
}
\description{
Deletes a reference data source configuration from the specified
application configuration.
}
\details{
If the application is running, Amazon Kinesis Analytics immediately
removes the in-application table that you created using the
AddApplicationReferenceDataSource operation.

This operation requires permissions to perform the
\code{kinesisanalytics.DeleteApplicationReferenceDataSource} action.
}
\section{Request syntax}{
\preformatted{svc$delete_application_reference_data_source(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  ReferenceId = "string"
)
}
}

\keyword{internal}
