% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_list_ml_transforms}
\alias{glue_list_ml_transforms}
\title{Retrieves a sortable, filterable list of existing AWS Glue machine
learning transforms in this AWS account, or the resources with the
specified tag}
\usage{
glue_list_ml_transforms(NextToken, MaxResults, Filter, Sort, Tags)
}
\arguments{
\item{NextToken}{A continuation token, if this is a continuation request.}

\item{MaxResults}{The maximum size of a list to return.}

\item{Filter}{A \code{TransformFilterCriteria} used to filter the machine learning
transforms.}

\item{Sort}{A \code{TransformSortCriteria} used to sort the machine learning transforms.}

\item{Tags}{Specifies to return only these tagged resources.}
}
\description{
Retrieves a sortable, filterable list of existing AWS Glue machine
learning transforms in this AWS account, or the resources with the
specified tag. This operation takes the optional \code{Tags} field, which you
can use as a filter of the responses so that tagged resources can be
retrieved as a group. If you choose to use tag filtering, only resources
with the tags are retrieved.
}
\section{Request syntax}{
\preformatted{svc$list_ml_transforms(
  NextToken = "string",
  MaxResults = 123,
  Filter = list(
    Name = "string",
    TransformType = "FIND_MATCHES",
    Status = "NOT_READY"|"READY"|"DELETING",
    GlueVersion = "string",
    CreatedBefore = as.POSIXct(
      "2015-01-01"
    ),
    CreatedAfter = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedBefore = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedAfter = as.POSIXct(
      "2015-01-01"
    ),
    Schema = list(
      list(
        Name = "string",
        DataType = "string"
      )
    )
  ),
  Sort = list(
    Column = "NAME"|"TRANSFORM_TYPE"|"STATUS"|"CREATED"|"LAST_MODIFIED",
    SortDirection = "DESCENDING"|"ASCENDING"
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
