% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_delete_application_output}
\alias{kinesisanalyticsv2_delete_application_output}
\title{Deletes the output destination configuration from your SQL-based Kinesis
Data Analytics application's configuration}
\usage{
kinesisanalyticsv2_delete_application_output(ApplicationName,
  CurrentApplicationVersionId, OutputId)
}
\arguments{
\item{ApplicationName}{[required] The application name.}

\item{CurrentApplicationVersionId}{[required] The application version. You can use the DescribeApplication operation
to get the current application version. If the version specified is not
the current version, the \code{ConcurrentModificationException} is returned.}

\item{OutputId}{[required] The ID of the configuration to delete. Each output configuration that is
added to the application (either when the application is created or
later) using the AddApplicationOutput operation has a unique ID. You
need to provide the ID to uniquely identify the output configuration
that you want to delete from the application configuration. You can use
the DescribeApplication operation to get the specific \code{OutputId}.}
}
\description{
Deletes the output destination configuration from your SQL-based Kinesis
Data Analytics application's configuration. Kinesis Data Analytics will
no longer write data from the corresponding in-application stream to the
external output destination.
}
\section{Request syntax}{
\preformatted{svc$delete_application_output(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  OutputId = "string"
)
}
}

\keyword{internal}
