% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_template_versions}
\alias{quicksight_list_template_versions}
\title{Lists all the versions of the templates in the current Amazon QuickSight
account}
\usage{
quicksight_list_template_versions(AwsAccountId, TemplateId, NextToken,
  MaxResults)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the templates that you're
listing.}

\item{TemplateId}{[required] The ID for the template.}

\item{NextToken}{The token for the next set of results, or null if there are no more
results.}

\item{MaxResults}{The maximum number of results to be returned per request.}
}
\value{
A list with the following syntax:\preformatted{list(
  TemplateVersionSummaryList = list(
    list(
      Arn = "string",
      VersionNumber = 123,
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      Status = "CREATION_IN_PROGRESS"|"CREATION_SUCCESSFUL"|"CREATION_FAILED"|"UPDATE_IN_PROGRESS"|"UPDATE_SUCCESSFUL"|"UPDATE_FAILED"|"DELETED",
      Description = "string"
    )
  ),
  NextToken = "string",
  Status = 123,
  RequestId = "string"
)
}
}
\description{
Lists all the versions of the templates in the current Amazon QuickSight
account.
}
\section{Request syntax}{
\preformatted{svc$list_template_versions(
  AwsAccountId = "string",
  TemplateId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
